<?php $__env->startSection('title', 'ورود'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row g-0">
        <div class="col-xl-3">
            <div class="auth-full-page-content p-md-5 p-4">
                <div class="w-100">
                    <div class="d-flex flex-column h-100">
                        <div class="mb-4 mb-md-5">
                            <a href="#" class="d-block auth-logo">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="<?php echo e(getSetting('app_name_farsi')); ?> logo" height="18" class="auth-logo-dark">
                                <img src="<?php echo e(asset('images/logo/logo-light.svg')); ?>" alt="<?php echo e(getSetting('app_name_farsi')); ?> logo" height="18" class="auth-logo-light">
                            </a>
                        </div>
                        <div class="my-auto">
                            <div>
                                <h5 class="text-primary">ورود به پنل ادمین</h5>
                                <p class="text-muted">ایمیل و رمز عبور خود را برای ورود وارد نمایید</p>
                            </div>
                            <?php if(Session::has('Error')): ?>
                                <div class="alert alert-warning alert-dismissible" role="alert">
                                    <i class="mdi mdi-alert-outline me-2"></i>
                                    <?php echo e(Session::get('Error')); ?>

                                    <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                                    </button>
                                </div>
                            <?php endif; ?>
                            <div class="mt-4">
                                <form method="POST" autocomplete="off" id="loginform" class="form-horizontal needs-validation" action="<?php echo e(Route('A-loginPost')); ?>" novalidate>
                                    <?php echo csrf_field(); ?>
                                    <div class="mb-3">
                                        <label for="username" class="form-label">ایمیل</label>
                                        <input type="email" class="form-control" required="required"
                                               name="email" id="mobile"/>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">رمز عبور</label>
                                        <div class="input-group auth-pass-inputgroup">
                                            <input type="password" class="form-control" id="password"
                                                   minlength="6" name="password" required="required">
                                            <button class="btn btn-light " type="button" id="password-addon"><i class="mdi mdi-eye-outline"></i></button>
                                        </div>
                                    </div>
                                    <div class="mt-3 d-grid">
                                        <button type="submit" class="btn btn-primary waves-effect waves-light"
                                                data-callback="onSubmitloginform">ورود</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="mt-4 mt-md-5 text-center">
                            <p>© <script>document.write(new Date().getFullYear())</script> ساخته شده با <i class="mdi mdi-heart text-danger"></i> توسط تیم <?php echo e(getSetting('app_name_farsi')); ?></p>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <div class="col-xl-9">
            <div class="auth-full-bg pt-lg-5 p-4">
                <div class="w-100">
                    <div class="bg-overlay"></div>
                    <div class="d-flex h-100 flex-column">
                        <div class="p-4 mt-auto">
                            <div class="row justify-content-center">
                                <div class="col-lg-7">
                                    <div class="text-center">
                                        <h4 class="mb-3"><i class="bx bxs-quote-alt-left text-primary h1 align-middle me-3"></i>ورود دو مرحله را فعال کنید <span class="text-primary">آموزش بزودی ...</span></h4>
                                        <div dir="ltr">
                                            <div class="owl-carousel owl-theme auth-review-carousel" id="auth-review-carousel">
                                                <div class="item">
                                                    <div class="py-3">
                                                        <p class="font-size-16 mb-4">قابلیت تایید دو مرحله ای یکی از بهترین روشها برای تامین امنیت در وب است. قابلیت تایید دو مرحله ای این امکان را فراهم می کند که بتوان تصدیق ورود را در دو مرحله متفاوت از هم انجام داد. در اینصورت میزان امنیت بسیار بالاتر خواهد بود. یکی از روشهای متدوال در تایید هویت دومرحله ای، تایید با پیامک و یا تماس تلفنی است. با فعال بودن این قابلیت، حتی اگر اطلاعات حساب شما به دست هکر بیافتد برای ورود به حساب شما می بایست کد تاییدیه را نیز داشته باشد!</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function onSubmitloginform(){
            if($("#mobile:invalid").length==1 | $("#password:invalid").length==1){
                ElementUnBlock('form button');
                $('form').addClass('was-validated');
            }
            else
                $('form').submit();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.auth.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>