<?php $__env->startSection('title', 'سفارشات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارشات</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>">داشبورد</a></li>
                        <li class="breadcrumb-item active">سفارشات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-4">
                        <div class="card-title mb-0">لیست سفارشات شما</div>
                    </div>
                    <div class="col-md-12">
                        <div class="row justify-content-between">
                            <div class="col-md-3">
                                <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                            </div>
                            <div class="col-md-3 d-flex">
                                <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-nowrap" id="myTable">
                            <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>ارز</th>
                                <th>نوع سفارش</th>
                                <th>مقدار</th>
                                <th>تاریخ و ساعت ثبت</th>
                                <th>وضعیت</th>
                                <th>مبلغ سفارش</th>
                                <th>جزئیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i); ?></td>
                                    <td>
                                        <img class="me-1" src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($order->orders_model); ?>.svg" width="25px">
                                        <?php echo e($order->orders_model); ?>

                                    </td>
                                    <td>
                                        <?php if($order->type == 'sell'): ?>
                                            فروش
                                        <?php elseif($order->type == 'buy'): ?>
                                            خرید
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($order->amount_coin); ?></td>
                                    <td><?php echo e($order->created_at); ?></td>
                                    <td><?php echo e($order->status); ?></td>
                                    <td><?php echo e($order->amount); ?> <small>تومان</small></td>
                                    <td><a class="btn btn-light btn-sm" href="<?php echo e(asset('')); ?>orders/<?php echo e($order->id); ?>"><small>مشاهده سفارش</small></a></td>
                                </tr>
                                <?php $i++ ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/orders/orders.blade.php ENDPATH**/ ?>