<?php $__env->startSection('title', 'گزارشات'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('')); ?>app-assets/css/plugins/persian-datepicker.min.css">

    <style>
        .height-500 {
            height: 500px !important;
        }
        .height-400 {
            height: 400px !important;
        }
        .height-300 {
            height: 300px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="card-title mb-0">گزارشات در بازه زمانی</div>
                <p class="text-small text-muted">گزارشات داشبورد را در بازه زمانی مورد نظر مشاهده کنید</p>
                <div class="row mx-auto">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="ul-form__label"> گزارش از تاریخ</label>
                            <div class="input-group">
                                <input type="text" class="form-control text-center font-small-2 px-0" value="<?php echo e($date->start1); ?>" id="date_start" placeholder="تاریخ">
                                <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="ul-form__label">تا تاریخ</label>
                            <div class="input-group">
                                <input type="text" class="form-control text-center font-small-2 px-0" value="<?php echo e($date->stop1); ?>" id="date_stop" placeholder="تاریخ">
                                <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="my-4 text-center">
                        <button class="btn btn-primary btn btn-block" onclick="loading();load()">نمایش</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="load" style="display: none"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/charts/chart.min.js" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>


        $(window).on("load", function(){
            loading();
            load();
        });

        new persianDate().format();

        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            initialValueType: 'persian',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            initialValueType: 'persian',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        })



        function load(){
            $('#load').load("<?php echo e(asset('').env('PanelPrefix')); ?>/reports/load?date_start="+ $("#date_start").val().replace(" ", "%20") + "&date_stop="+ $("#date_stop").val().replace(" ", "%20") );
            $('#load').fadeOut()
            $('#load').fadeIn();
            unloading();
        }


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/admin/reports/reports.blade.php ENDPATH**/ ?>