<?php $__env->startSection('title', 'فروشگاه محصولات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارش پول دیجیتال</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">لیست سفارشات</div>
                </div>
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#all" role="tab">
                            <span>همه سفارشات</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#completed" role="tab">
                            <span>تکمیل شده</span>
                        </a>
                    </li>
                </ul>

                <div class="tab-content p-3 text-muted">
                    <div class="tab-pane active" id="all" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>نام محصول</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <?php if( isset($orders) ): ?>
                                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($order->id); ?></td>
                                                <td><?php echo e($order->product_title); ?></td>
                                                <td><?php echo e(number_format($order->final_price)); ?><small class="ms-1">تومان</small></td>
                                                <td>
                                                    <?php if( $order->status == 'payment-confirm' ): ?>
                                                        <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                                    <?php elseif( $order->status == 'payment-pending' ): ?>
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                    <?php elseif( $order->status == 'payment-cancel' ): ?>
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">پرداخت ناموفق</span>
                                                    <?php elseif( $order->status == 'done' ): ?>
                                                        <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                    <?php elseif( $order->status == 'cart' ): ?>
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">سبد خرید</span>
                                                    <?php elseif( $order->status == 'canceled' ): ?>
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($order->date); ?></td>
                                                <td>
                                                    <a class="btn btn-primary btn-sm btn-rounded" href="<?php if( $order->status == 'cart'): ?> <?php echo e(asset('')); ?>cart <?php else: ?> <?php echo e(asset('')); ?>product-orders/<?php echo e($order->id); ?> <?php endif; ?>">مشاهده</a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($orders->fragment('all')->links()); ?>

                        </div>
                    </div>
                    <div class="tab-pane" id="completed" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>تصویرمحصول</th>
                                    <th>نام محصول</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <?php if( isset($completedOrders) ): ?>
                                        <?php $__currentLoopData = $completedOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($order->id); ?></td>
                                                <td>
                                                    <img width="70px" src="<?php echo e(asset($order->product->image)); ?>" />
                                                </td>
                                                <td><?php echo e($order->product->title); ?></td>
                                                <td><?php echo e(number_format($order->final_price)); ?><small class="ms-1">تومان</small></td>
                                                <td>
                                                    <?php if( $order->status == 'done' ): ?>
                                                        <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($order->date); ?></td>
                                                <td>
                                                    <a class="btn btn-primary btn-sm btn-rounded" href="/product-orders/<?php echo e($order->id); ?>">مشاهده</a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($completedOrders->fragment('completed')->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {

            var url = document.location.toString();
            if (url.match('#')) {
                $('.nav-tabs a[href="#' + url.split('#')[1] + '"]')[0].click();
            }

            //To make sure that the page always goes to the top
            setTimeout(function () {
                window.scrollTo(0, 0);
            },200);

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/ecommerce/shop-orders.blade.php ENDPATH**/ ?>