<?php $__env->startSection('title', 'تراکنش های کیف پول'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('')); ?>app-assets/vendors/css/tables/datatable/datatables.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('')); ?>app-assets/css/plugins/persian-datepicker.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div class="card-title mb-0">تراکنش های کیف پول</div>
                    <button class="btn btn-light" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                        <i class="mdi mdi-filter"></i> فیلترکردن
                    </button>
                </div>
                <p class="mb-4">تراکنش های کیف پول کاربران را مشاهده میکنید</p>
                <div class="collapse mt-4" id="collapseExample">
                    <div class="card border shadow-none card-body text-muted mb-0">
                        <div class="row">
                            <div class="col-md-2 form-group mb-md-0 offset-md-2 d-none">
                                <label>وضعیت</label>
                                <select class="form-control round" id="status">
                                    <option value="" selected>همه</option>
                                    <option value="موفق">موفق</option>
                                    <option value="در دست اقدام">در دست اقدام</option>
                                    <option value="واریز شده">واریز شده</option>
                                    <option value="معلق,پرداخت شده">معلق و پرداخت شده</option>
                                    <option value="معلق,عودت">معلق و عودت</option>
                                    <option value="رد شده">رد شده</option>
                                </select>
                            </div>

                            <div class="col-md-2 form-group mb-md-0 offset-md-2">
                                <label>بانک</label>
                                <select name="bank_name" id="bank_name" class="form-control round text-center">
                                    <option value="" selected>همه</option>
                                    <option value="بانک ملی">بانک ملی</option>
                                    <option value="بانک ملت">بانک ملت</option>
                                    <option value="غیر ملت">غیر از بانک ملت</option>
                                    <option value="بانک سپه">بانک سپه</option>
                                    <option value="بانک تجارت">بانک تجارت</option>
                                    <option value="بانک مسکن">بانک مسکن</option>
                                    <option value="بانک صادرات">بانک صادرات</option>
                                    <option value="بانک کشاورزی">بانک کشاورزی</option>
                                    <option value="بانک رفاه">بانک رفاه</option>
                                    <option value="بانک سامان">بانک سامان</option>
                                    <option value="بانک پارسیان">بانک پارسیان</option>
                                    <option value="بانک پاسارگاد">بانک پاسارگاد</option>
                                    <option value="بانک سینا">بانک سینا</option>
                                    <option value="بانک دی">بانک دی</option>
                                    <option value="بانک شهر">بانک شهر</option>
                                    <option value="بانک سرمایه">بانک سرمایه</option>
                                    <option value="بانک اقتصاد نوین">بانک اقتصاد نوین</option>
                                    <option value="بانک مهر اقتصاد">بانک مهر اقتصاد</option>
                                    <option value="بانک قرض الحسنه مهر ایران">بانک قرض الحسنه مهر ایران</option>
                                    <option value="بانک انصار">بانک انصار</option>
                                    <option value="بانک ایران زمین">بانک ایران زمین</option>
                                    <option value="بانک حکمت ایرانیان">بانک حکمت ایرانیان</option>
                                    <option value="پست بانک">پست بانک</option>
                                    <option value="بانک گردشگری">بانک گردشگری</option>
                                    <option value="بانک کارآفرین">بانک کارآفرین</option>
                                    <option value="بانک قوامین">بانک قوامین</option>
                                    <option value="بانک توسعه صادرات ایران">بانک توسعه صادرات ایران</option>
                                    <option value="بانک توسعه تعاون">بانک توسعه تعاون</option>
                                    <option value="موسسه اعتباری کوثر">موسسه اعتباری کوثر</option>
                                    <option value="موسسه اعتباری توسعه">موسسه اعتباری توسعه</option>
                                    <option value="سایر">سایر</option>
                                </select>
                            </div>

                            <div class="col-md-2 form-group mb-md-0">
                                <label class="ul-form__label">از تاریخ</label>
                                <div class="input-group">
                                    <input type="text" class="form-control round text-center font-small-2 px-0" id="date_start" placeholder="تاریخ">
                                    <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                </div>
                            </div>
                            <div class="col-md-2 form-group mb-md-0">
                                <label class="ul-form__label">تا تاریخ</label>
                                <div class="input-group">
                                    <input type="text" class="form-control round text-center font-small-2 px-0" id="date_stop" placeholder="تاریخ">
                                    <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                </div>
                            </div>
                            <div class="clearfix w-100"></div>
                            <div class="col-md-2 form-group mb-md-0 mt-2 offset-md-2">
                                <label>مبلغ از</label>
                                <input type="text" class="form-control round text-center text-13 ltr-dir" id="amount_start" placeholder="مبلغ از">
                            </div>
                            <div class="col-md-2 form-group mb-md-0 mt-2">
                                <label>تا مبلغ</label>
                                <input type="text" class="form-control round text-center text-13 ltr-dir" id="amount_stop" placeholder="تا مبلغ">
                            </div>
                            <div class="my-4 text-center">
                                <label for="picker1"></label>
                                <button class="btn btn-primary btn-round btn-block" onclick="search()">فیلتر</button>
                            </div>
                        </div>
                    </div>
                </div>

                <p class="text-center font-weight-bold mt-4 mb-4">
                    جمع کل مبلغ: <span id="TotalAmount"> 0 </span>
                    <br>
                    <small>جمع کل رکورد های صفحه جاری را مشاهده میکنید و برای جمع کل همه نمایش تعداد را روی All بگذارید</small>
                    <span id="shaba"></span>
                </p>

                <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                       id="table_category">
                    <thead class='iransensbold'>
                    <tr>
                        <th class="text-center">#</th>
                        <th class="text-center ">نام کاربر</th>
                        <th class="text-center ">نوع</th>
                        <th class="text-center">مبلغ</th>
                        <th class="text-center">موجودی</th>
                        <th class="text-center">تاریخ و ساعت ثبت</th>
                        <th class="text-center">شرح</th>
                        <th class="text-center">وضعیت</th>
                        <th class="text-center">جزئیات</th>
                    </tr>
                    </thead>
                    <tbody  class="text-center">
                    </tbody>
                </table>

            </div>
        </div>
    </div>

    <!-- Modal -->
    <div id="Info" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">اطلاعات حساب</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/digitbox.min.js"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('#amount_start,#amount_stop').digitbox({separator:',', grouping:1, truevalue:1});

        function Info(id){
            $('#Info .modal-body').load("<?php echo e(asset('').env('PanelPrefix')); ?>/finances/"+id+'/?'+ new Date().getTime()).fadeIn();
            $('#Info').modal('show');
        }
        $('#Info').on('hidden.bs.modal', function () {
            $('#Info .modal-body').html('<div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>');
        })

        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });


        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "<?php echo e(asset('')); ?>app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '<?php echo e(asset('').env('PanelPrefix')); ?>/finances/list',
            "order": [[ "5", 'desc' ]],
            "processing": true,
            "serverSide": true,
            "columns": [
                { "data": "0" },
                { "data": function ( data) {return data['1']+' '+data['22']}},
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
                { "data": "5" },
                { "data": "6" },
                { "data": "7" },
                { "data": "8" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="mdi mdi-printer"></i> پرینت',
                    className: 'btn round btn-outline-secondary',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="mdi mdi-file-excel"></i> اکسل',
                    className: 'btn round btn-outline-secondary',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                }
            ],
            aLengthMenu: [
                [25, 50, 100, 200, -1],
                [25, 50, 100, 200, "All"]
            ],
            "fnDrawCallback": function(oSettings) {
                page = $('.alt-pagination').DataTable().page.info()['page'];
                if (page ==0 && $('.alt-pagination tr').length < 25) {
                    $('.dataTables_paginate,.dataTables_info').hide();
                }else
                    $('.dataTables_paginate,.dataTables_info').show();

            },"footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;

                // converting to interger to find total
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };

                // computing column Total of the complete result
                var AmountTotal = api
                    .column( 3 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                $('#TotalAmount').html(AmountTotal);




                $('#shaba').html('<br><button type="button" class="btn btn-sm btn-light" onclick="hesab()">لیست حساب</button>');
                $('#shaba').append('<button type="button" class="btn btn-sm btn-light m-1" onclick="shaba()">لیست شبا</button>');
                $('#shaba').append('<button type="button" class="btn btn-sm btn-light" onclick="confirm()" data-toggle="modal" data-target=".bd-example-modal-xl">پرداخت گروهی</button>');

            },
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });

        function search(){
            var tbl = $('.alt-pagination').DataTable();
            tbl.ajax.url("<?php echo e(asset('').env('PanelPrefix')); ?>/finances/list?date_start="+ $("#date_start").val()
                + "&date_stop="+ $("#date_stop").val() + "&status="+ $("#status").val() + "&bank_name="+ $("#bank_name").val()
                + "&amount_start="+ $("#amount_start").val()+ "&amount_stop="+ $("#amount_stop").val()).load();
        }

        function hesab() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("<?php echo e(asset('').env('PanelPrefix')); ?>/finances/hesab?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }

        function shaba() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("<?php echo e(asset('').env('PanelPrefix')); ?>/finances/shaba?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }

        function confirm() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("<?php echo e(asset('').env('PanelPrefix')); ?>/actions/finance/all-confirm?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/admin/finance.blade.php ENDPATH**/ ?>