<?php $__env->startSection('title', 'ورود دو مرحله ای'); ?>
<link href="<?php echo e(asset('libs/toastr.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
<style>
    .disable-block {
        pointer-events: none;
        opacity: 0.4;
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-3">
            <?php echo $__env->make('user.profile.profile-detail', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="col-xl-9">
            <?php echo $__env->make('user.profile.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <div class="card-title">امنیت حساب کاربری</div>
                    <p class="mt-3">به منظور افزایش سطح ایمنی حساب کاربری خود می توانید احراز هویت دو مرحله ای را فعال کنید. با فعال کردن این قابلیت حساب کاربری شما در برابر حملات هکرها، فیشینگ و سوء استفاده افراد سودجو ایمن خواهد بود. </p>
                    <div class="col-12 border-primary p-2 border-bottom-accent-1">
                        <label class="switch switch-primary mr-3">
                            <input <?php if(Auth::user()->sms2fa==1): ?> checked <?php elseif(isset(Auth::user()->google2fa)): ?> disabled <?php endif; ?>  type="checkbox" value="1" id="2fa_sms">
                            <span class="slider"></span>
                            <span class="ms-2">احراز هویت دو مرحله ای از طریق کد پیامکی</span>
                        </label>

                        <div class="mt-2 <?php if(Auth::user()->sms2fa!=1): ?> disable-block <?php endif; ?>" id="block_sms">
                            <p>با فعالسازی این گزینه برای هر بار ورود به شماره موبایلی که ثبت کرده اید کد پنج رقمی ارسال میشود و آن کد را باید موقع ورود درج کنید.</p>
                        </div>
                    </div>

                    <div class="col-12 border-bottom-primary border-left-primary border-right-primary p-2">
                        <label class="switch switch-primary mr-3">
                            <input type="checkbox" <?php if(Auth::user()->google2fa!=""): ?> checked disabled <?php elseif(Auth::user()->sms2fa==1): ?> disabled <?php endif; ?> id="2fa_google">
                            <span class="slider"></span>
                            <span class="ms-2">احراز هویت دو مرحله ای با Google Authenticator</span>
                        </label>

                        <div class="mt-2 <?php if(Auth::user()->google2fa==""): ?> disable-block <?php endif; ?>" id="block_google">
                            <?php if(!isset(Auth::user()->google2fa)): ?>
                                <p>جهت فعال سازی این قابلیت، مراحل زیر را دنبال کنید:</p>
                                <p>1. آخرین نسخه Google Authenticator را از گوگل پلییا اپل استور دریافت نمایید. <br>2. پس از نصب و اجرای برنامه Google Authenticator از طریق یکی از روش های زیر، کلید را به برنامه اضافه نمایید. <br>3. Scan a barcode (اسکن بارکد): این گزینه را انتخاب کرده و بارکد زیر را اسکن نمایید</p>
                                <div class="text-center"><?php echo $goole2fa['inlineUrl']; ?></div>
                                <div class="text-center">
                                    <span>و یا می توانید با استفاده از کلید Enter a provided key  این گزینه را انتخاب کرده و کد زیر را به دقت وارد نمایید.</span>
                                    <h3 class="text-info my-3" style="font-family: Sans-Serif"><?php echo e($goole2fa['secret']); ?></h3>
                                </div>
                                <form class="w-100 needs-validation" action="" novalidate>
                                    <div class="row mt-2 text-center">
                                        <span class="mb-2">کد دریافتی (عدد 6 رقمی) را در کادر زیر وارد نموده و دکمه فعال سازی را کلیک نمایید.</span>
                                        <div class="col-md-6 form-group mb-2 mx-auto">
                                            <input type="text" class="form-control text-center ltr-dir" required
                                                   id="code" name="code" minlength="6" maxlength="6" placeholder="عدد 6 رقمی">
                                            <div class="invalid-feedback">کد 6 رقمی در اپلیکیشن را درج کنید</div>
                                        </div>
                                        <div>
                                            <button onclick="google2fa()" type="button" class="btn btn-primary btn-block">فعال سازی
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            <?php else: ?>
                                <p>جهت غیرفعال سازی این قابلیت، بایستی کد درج شده در اپلیکیشن را در فیلد زیر درج کنید و دکمه غیر فعالسازی رو بزنید.</p>
                                <form class="w-100 needs-validation" action="" novalidate>
                                    <div class="row mt-2">
                                        <div class="col-md-5 col-12 form-group mb-2">
                                            <input type="text" class="form-control text-center ltr-dir" required
                                                   id="code" name="code" minlength="6" maxlength="6" placeholder="عدد 6 رقمی">
                                            <div class="invalid-feedback">کد 6 رقمی در اپلیکیشن را درج کنید</div>
                                        </div>
                                        <div class="col-md-3">
                                            <button onclick="google2fa()" type="button" class="btn btn-primary btn-block">غیرفعال سازی
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('libs/toastr.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('#2fa_sms').click(function () {
            loading();
            if ($(this).is(':checked')) {
                var sms = 1;
                $('#block_sms').removeClass('disable-block');
                $('#block_google').addClass('disable-block');
                $('#2fa_google').prop('checked', false);
                $('#2fa_google').prop('disabled', true);
            } else {
                var sms = 0;
                $('#block_sms').addClass('disable-block');
                $('#2fa_google').prop('disabled', false);
            }

            $.post("<?=asset('');?>profile/two-factor-authentication/sms",
            {
                sms: sms,
                _token: "<?php echo e(csrf_token()); ?>",
            },
            function (data) {
                unloading();
                if (data.status == true) {
                    toastr.success(data.message, "انجام شد!", {
                        positionClass: "toast-bottom-right",
                        progressBar: !0,
                    })
                } else {
                    toastr.error(data.message, "خطا!", {
                        positionClass: "toast-bottom-right",
                        progressBar: !0,
                    })
                }
            });

        });

        $('#2fa_google').click(function () {
            if ($(this).is(':checked')) {
                $('#block_google').removeClass('disable-block');
                $('#block_sms').addClass('disable-block');
                $('#2fa_sms').prop('checked', false);
                $('#2fa_sms').prop('disabled', true);
            } else {
                $('#block_google').addClass('disable-block');
                $('#2fa_sms').prop('disabled', false);
            }
        });

        function google2fa(){
            if($("#code:invalid").length==1)
                $('form').addClass('was-validated');
            else{
                loading();
                $.post("<?=asset('');?>profile/two-factor-authentication/google",
                {
                    code: $("#code").val(),
                    _token: "<?php echo e(csrf_token()); ?>",
                },
                function (data) {
                    unloading();
                    if (data.status == true) {
                        swal.fire({
                            type: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.reload();
                            }
                        });
                    } else {
                        toastr.error(data.message, "خطا!", {
                            positionClass: "toast-bottom-right",
                            progressBar: !0,
                        })
                    }
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/profile/profile-2fa.blade.php ENDPATH**/ ?>