<?php $__env->startSection('title', 'خرید '.$Crypto->name_fa); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">خرید <?php echo e($Crypto->name_fa); ?></h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>wallet">بازار ارزهای دیجیتال</a></li>
                        <li class="breadcrumb-item active">خرید <?php echo e($Crypto->name_fa); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3">
                            <img src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($Crypto->name); ?>.svg" alt="" class="avatar-md rounded-circle img-thumbnail">
                        </div>
                        <div class="flex-grow-1 align-self-center">
                            <div class="text-muted">
                                <h5><?php echo e($Crypto->name_fa); ?></h5>
                                <p class="mb-1"><?php echo e($Crypto->symbol); ?></p>
                            </div>
                        </div>
                        <div class="dropdown">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-wallet me-1"></i> <span class="d-none d-sm-inline-block">کیف پول ریالی <i class="mdi mdi-chevron-down"></i></span></button>
                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-md">
                                <div class="dropdown-item-text">
                                    <div>
                                        <p class="text-muted mb-2">موجودی در دسترس</p>
                                        <h5 class="mb-0"><?php echo e(number_format(Auth::user()->wallet)); ?></h5>
                                    </div>
                                </div>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item text-primary text-center" href="<?php echo e(asset('')); ?>wallet" target="_blank">
                                    شارژ کیف پول
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row" id="coinCalculator">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="mt-4">
                        <ul class="nav nav-pills bg-light rounded" role="tablist">
                            <li class="nav-item">
                                <a class="btn btn-success text-white" href="#buy-tab">خرید</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(asset('')); ?><?php echo e($Crypto->name); ?>/sell">فروش</a>
                            </li>
                        </ul>
                        <div class="tab-content mt-4">
                            <div id="buy-tab">
                                <div>
                                    <div class="row mb-3">
                                        <div class="col-6 col-xl-4 col-sm-4 text-center">
                                            <div class="d-flex">
                                                <div class="flex-grow-1">
                                                    <p class="text-muted mb-2">هر یک <?php echo e($Crypto->name_fa); ?></p>
                                                    <h6>
                                                        {{ fee }}
                                                        <span class="spinner-grow text-primary" v-if="isLoading" role="status" style="height: 17px;width: 17px"></span> تومان
                                                    </h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 col-xl-4 col-sm-4 text-center">
                                            <div class="mt-sm-0">
                                                <p class="text-muted mb-2">موجودی</p>
                                                <h6>
                                                    {{ stock }}
                                                    <span class="spinner-grow text-primary" v-if="isLoading" role="status" style="height: 17px;width: 17px"></span> کوین
                                                </h6>
                                            </div>
                                        </div>
                                        <div class="col-6 col-xl-4 col-sm-4 text-center">
                                            <div class="mt-sm-0">
                                                <p class="text-muted mb-2">موجودی تومانی</p>
                                                <h6>
                                                    {{ stock_ir }}
                                                    <span class="spinner-grow text-primary" v-if="isLoading" role="status" style="height: 17px;width: 17px"></span> تومان
                                                </h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <form id="coin_buy" class="mt-2 needs-validation" novalidate action="" autocomplete="off" method="post">
                                            <?php echo csrf_field(); ?>
                                            <label>مقدار <?php echo e($Crypto->name_fa); ?></label>
                                            <div class="input-group mb-3">
                                                <label class="input-group-text">
                                                    <img src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($Crypto->name); ?>.svg" alt="<?php echo e($Crypto->symbol); ?>" width="20px">
                                                </label>
                                                <input id="coin" name="coin" maxlength="10" autocomplete="off" ref="coinInput"
                                                       v-on:keyup="calculateResult('coin')" v-model="coin" :readonly="isLoading"
                                                       class="form-control text-center">
                                                <label class="input-group-text"><?php echo e($Crypto->symbol); ?></label>
                                            </div>

                                            <div class="input-group mb-3">
                                                <label class="input-group-text">
                                                    <img src="<?php echo e(asset('')); ?>app-assets/images/currency/iran.svg" width="20px">
                                                </label>
                                                <input id="network_name" name="network_name" v-model="network_name" type="hidden" />
                                                <input id="amount" name="amount" maxlength="12" <?php if(isset($_GET['amount'])): ?> value="<?php echo e($_GET['amount']); ?>"<?php endif; ?>
                                                v-on:keyup="calculateResult('rial')" v-model="rial" :readonly="isLoading"
                                                       class="form-control text-center">
                                                <label class="input-group-text">تومان</label>
                                            </div>
                                            <div class="col-md-12 p-0 form-group my-5">
                                                <ul class="nav nav-pills nav-justified mb-2 bg-light" role="tablist">
                                                    <?php $__currentLoopData = $networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="nav-item waves-effect waves-light" v-on:click="network_fee = <?php echo e($item['fee']); ?>; network_name = '<?php echo e($item['network']); ?>'; calculateResult('coin',true);">
                                                        <a class="nav-link <?php echo e($key == 0 ? 'active' : ''); ?>" data-bs-toggle="tab" href="" role="tab">
                                                            <span><?php echo e($item['network']); ?></span>
                                                        </a>
                                                    </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                                <label for="firstName1">کارمزد شبکه</label>
                                                <span class="form-control text-center text-primary bg-light disabled" style="background-color: #EEE;" id="transfer_fee">
                                                    <span v-if="network_fee == false">
                                                        {{ transfer_fee }}<?php echo e($Crypto->symbol); ?> معادل
                                                        {{ transfer_fee_amount }}
                                                    </span>
                                                    <span v-else>
                                                        {{ network_fee }}<?php echo e($Crypto->symbol); ?> معادل
                                                        {{ new Intl.NumberFormat('en-US').format(network_fee * pure_fee) }}
                                                    </span>
                                                    <span v-if="isLoading">
                                                        <span class="spinner-grow text-primary" role="status" style="height: 17px;width: 17px"></span>
                                                    </span>
                                                    تومان
                                                </span>
                                            </div>
                                            <div class="col-md-12 p-0 form-group mb-3">
                                                <label for="firstName1">کارمزد خرید</label>
                                                <span class="form-control text-center text-primary bg-light disabled" style="background-color: #EEE;" id="transfer_fee">
                                                    {{ show_order_fee }}
                                                    <span v-if="isLoading">
                                                        <span class="spinner-grow text-primary" role="status" style="height: 17px;width: 17px"></span>
                                                    </span>
                                                    تومان
                                                </span>
                                            </div>
                                            <div class="col-md-12 p-0 form-group mb-3" id="box-wallet">
                                                <label for="phone">آدرس کیف پول جهت واریز</label>
                                                <select class="form-control" name="destination" id="destination" required>
                                                    <option value="" disabled="" selected="">آدرس کیف پول را انتخاب کنید</option>
                                                    <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($wallet->wallet); ?>"><?php echo e($wallet->coin_name); ?> - <?php echo e($wallet->wallet); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback">آدرس کیف پول و یا واریز به کیف پول را انتخاب کنید </div>
                                                <small class="mr-2">لیست آدرس کیف پول های تایید شده را مشاهده میکنید.
                                                    <?php if(count($result)==0): ?>
                                                        <a href="<?php echo e(asset('')); ?>profile/wallet"><span class="text-danger">آدرس کیف پول تایید شده ای ندارید!</span></a>
                                                    <?php endif; ?>
                                                </small>
                                            </div>
                                            <?php if($Crypto->destination_tag == 1): ?>
                                                <div class="col-md-12 p-0 form-group mb-1">
                                                    <label for="firstName1">دارای تگ میباشد؟</label>
                                                    <div class="mr-2 d-xl-flex d-sm-flex d-block d-md-block">

                                                        <label class="radio radio-outline-primary mx-1 m-xl-0">
                                                            <input type="radio" name="has_destination_tag" v-model="has_destination_tag" id="has_destination_tag" checked value="0">
                                                            <span>خیر</span>
                                                            <span class="checkmark"></span>
                                                        </label>
                                                        <label class="radio radio-outline-primary mx-1">
                                                            <input type="radio"  name="has_destination_tag" v-model="has_destination_tag" id="has_destination_tag" value="1">
                                                            <span>بله</span>
                                                            <span class="checkmark"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <transition name="slide">
                                                    <div class="col-md-12 p-0 form-group" v-if="has_destination_tag == 1">
                                                        <input type="text" class="form-control text-center ltr-dir"
                                                               :required="has_destination_tag == 1 ? true : false"
                                                               id="destination_tag" name="destination_tag" maxlength="60" placeholder="تگ">
                                                        <div class="invalid-feedback">تگ را درج کنید</div>
                                                    </div>
                                                </transition>
                                            <?php endif; ?>
                                            <div class="card border border-success my-4">
                                                <div class="text-center py-3">مبلغ پرداختی: <span id="payment">{{payment}}</span></div>
                                            </div>
                                            <?php if(Auth::user()->auth_img_confirm != 1 || Auth::user()->selfie_img_confirm != 1): ?>
                                                <div class="card border border-danger">
                                                    <div class="card-header bg-transparent border-danger">
                                                        <a href="<?php echo e(asset('')); ?>profile">
                                                            <span class="my-0 text-danger"><i class="mdi mdi-alert me-3"></i>احراز هویت شما کامل نشده!. برای خرید ارز لطفا احراز هویت خود را کامل کنید</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="my-3">
                                                    <?php echo $__env->make('user.layouts.BuyMethod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>
                                                <div class="text-center">
                                                    <button type="submit" class="btn btn-success w-md">ثبت و پرداخت</button>
                                                </div>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نمودار</h4>
                    <div class="mt-4">
                        <div id="tradingview_f6243"></div>
                        <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/<?php echo e($Crypto->name); ?>" rel="noopener" target="_blank"></a></div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <h5>نکات مهم در هنگام خرید</h5>
                    <hr>
                    <div class="text-14 mb-md-5">
                        <p>از آنجایی که تراکنش های <?php echo e($Crypto->name_fa); ?> غیر قابل بازگشت است، چنانچه آدرس عمومی شخص دریافت کننده
                            اعتبار را به اشتباه اعلام کنید، تراکنش و <?php echo e($Crypto->name_fa); ?> ارسال شده قابل بازگشت نخواهد بود.
                            بنابراین توصیه می کنیم پیش از ثبت سفارش، از آدرس عمومی (Public Address) دریافت کننده
                            مطمئن شوید.</p>
                        <p>به دلیل بار ترافیکی موجود در شبکه <?php echo e($Crypto->name_fa); ?>، شارژ <?php echo e($Crypto->name_fa); ?> ممکن است با تاخیر صورت پذیرد.
                            خواهشمندیم تا پایان فرآیند شکیبا باشید.</p>
                        <p>حساب گیرنده به میزان دلخواه شما با <?php echo e($Crypto->name_fa); ?> و نه ارز های دیگر مانند دلار یا یورو شارژ
                            خواهد شد.</p>
                        <p>جهت استفاده از خدمات شارژ <?php echo e($Crypto->name_fa); ?>، پیش از هر چیز می بایست نسبت به تایید هویت خود در پنل
                            کاربری <?php echo e(getSetting('app_name_farsi')); ?> اقدام کنید.</p>
                        <p>اطلاعات مربوط به حساب بانکی اعلام شده می بایست با مشخصات کاربری شما یکسان باشد در غیر این
                            صورت از انجام تراکنش معذوریم.</p>
                        <p>با توجه به غیر قابل برگشت بودن تراکنش <?php echo e($Crypto->name_fa); ?>، امکان لغو تراکنش یا بازگشت دادن وجه پس از
                            انجام شارژ <?php echo e($Crypto->name_fa); ?> امکان پذیر نیست.</p>
                        <p>از آنجایی که در حال حاضر قانونی در کشور و در رابطه با استفاده از ارز های رمزنگاری شده
                            تصویب نشده است، محدودیت در انجام معاملات با استفاده از <?php echo e($Crypto->name_fa); ?> وجود ندارد اما چنانچه در
                            آینده قانونی به تصویب برسد، موارد را به اطلاع شما خواهیم رساند.</p>
                        <p>به این دلیل که ارز های رمزنگاری شده تحت تاثیر برخی از عوامل ممکن است صعود یا سقوط ارزش را
                            به صورت ناگهانی تجربه کنند، <?php echo e(getSetting('app_name_farsi')); ?> همانگونه که منفعتی در قبال افزایش ارزش آن نمی برد،
                            مسئولیتی هم در قبال سقوط قیمت آن نخواهد داشت.</p>
                        <p>کارمزد پرداختی از سوی شما در سرعت پردازش تراکنش شما تاثیر خواهد داشت. پیشنهاد می کنیم در
                            انتخاب مبلغ تراکنش دقت نمایید چرا که در صورت تعیین میزان کارمزد پایین، تایید تراکنش شما
                            ممکن است چند روز زمان ببرد یا حتی اصلا صورت نگیرد.</p>
                        <p>در صورتی که موجودی <?php echo e($Crypto->name_fa); ?> <?php echo e(getSetting('app_name_farsi')); ?> در زمان سفارش کمتر از میزان درخواستی شما باشد، تکمیل
                            ظرفیت ممکن است نیازمند زمان باشد و البته در صورت بروز تغییر قابل توجه در قیمت <?php echo e($Crypto->name_fa); ?>،
                            موضوع به اطلاع شما خواهد رسید.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/digitbox.min.js')); ?>"></script>
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    <script type="text/javascript">
        new TradingView.widget(
            {
                "width": '100%',
                "height": '450',
                "symbol": "BINANCE:<?php echo e($Crypto->symbol); ?>USDT",
                "interval": "15",
                "timezone": "Etc/UTC",
                "theme": "light",
                "style": "1",
                "locale": "en",
                "toolbar_bg": "#f1f3f6",
                "enable_publishing": false,
                "hide_side_toolbar": false,
                "allow_symbol_change": true,
                "container_id": "tradingview_f6243"
            }
        );
    </script>

    <script>

        var url = $('meta[name=url]').attr("content");
        var csrf = $('meta[name=_token]').attr("content");

        const vm1 = new Vue({
            el: '#coinCalculator',
            data: {
                coinName: '<?php echo e($Crypto->name); ?>',
                coin: null,
                rial: <?php echo "'" . request('amount') . "'"; ?>,
                fee: null,
                pure_fee: null,
                type: 'buy',
                stock: null,
                stock_ir: null,
                isLoading: true,
                payment:0,
                getParam: null,
                serverCoinsPrice: {},
                transfer_fee: null,
                transfer_fee_amount: null,
                network_fee: <?php echo e($network['fee'] ?? 'false'); ?>,
                network_name: '<?php echo e(isset($networks[0]) ? $networks[0]['network'] : null); ?>',
                buy_order_fee: null,
                show_order_fee: 0,
                has_destination_tag:0
            },
            methods: {
                LoadedFee: function (coin) {
                    fetch(url +"infoCurrency/"+ this.coinName +'?type='+this.type,
                        {
                            method: 'POST',
                            mode: 'cors',
                            cache: 'no-cache',
                            headers: {
                                'Content-Type': 'application/json',
                                'Connection': 'keep-alive',
                            },
                            body: JSON.stringify({_token: csrf ,model:'buy'})
                        }
                    ).then(res => {
                        return res.json()
                    })
                        .then(data => {
                            this.serverCoinsPrice = data;
                            this.fee = data.fee.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                            this.pure_fee = data.fee;
                            this.stock = data.balances;
                            this.stock_ir = Math.round((data.fee * data.balances)).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                            this.transfer_fee = data.transfer_fee_amount;
                            this.buy_order_fee = data.buy_order_fee;
                            this.transfer_fee_amount = Math.round(data.transfer_fee_amount * data.fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                            this.isLoading = false;
                            // if(this.getParam){
                                // this.rial = this.getParam;
                            // this.calculateResult('rial', false);
                            this.calculateResult('coin', false);
                                // this.getParam = null
                            // }
                        });

                },
                calculateResult(model, update = true) {
                    if(update)
                        this.updatePrice();

                    fee = parseInt(this.fee.replace(/\,/g, ''));
                    network_fee = fee * this.network_fee;
                    transfer_fee = fee * this.transfer_fee;

                    if(model == 'coin'){
                        const coin = Math.round(this.coin * fee);
                        if(coin.toString() !== 'NaN') {
                            this.rial = coin.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                            var show_order_fee = parseInt((coin * (this.buy_order_fee / 100)).toFixed(0));
                            this.show_order_fee = new Intl.NumberFormat('en-US').format(show_order_fee);
                            //this.payment = coin + network_fee + show_order_fee;//).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                            this.payment = network_fee ? Math.round(coin + network_fee + show_order_fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") :  Math.round(coin + transfer_fee + show_order_fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")

                            // setTimeout(() => {
                            //       this.$refs.coinInput.focus();
                            //     }, 500);
                        }
                    }else{
                        /***** ramin ****/
                        amount = parseInt(this.rial.replace(/\,/g, ''))
                        this.rial = amount.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                        this.coin =   +((amount / fee).toFixed(<?php echo e($Crypto->percent); ?>));// Math.round((amount / fee))/10;
                        if(this.rial == 'NaN' || this.rial =='')
                            this.payment = 0;
                        else
                            this.payment =  Math.round(amount+network_fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                    }
                },
                updatePrice: (delay(function() {
                    this.LoadedFee();
                },30000)),
            },
            watch: {
                serverCoinsPrice: function (newValue,oldValue) {
                    if(oldValue.fee && (newValue.fee != oldValue.fee)){
                        this.calculateResult('coin',false)
                    }
                }
            },
            mounted() {
                this.LoadedFee();
                setInterval(() => {
                    this.LoadedFee();
                }, 20000);

                $('#coin').digitbox({float: true});
                $('#amount').digitbox({grouping: 1, separator: ',', truevalue: 1});

            },
            created()
            {
                let uri = window.location.search.substring(1);
                let params = new URLSearchParams(uri);
                // if(params.get("amount"))
                // this.getParam = params.get("amount")

            },
        })


        $(document).ready(function () {
            $('#coin_buy').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if ($('#coin').val() < <?php echo e($Crypto->min_buy); ?> ) {
                        Swal.fire({
                            icon: 'warning',
                            title: "توجه",
                            html: 'حداقل مجاز مقدار <?php echo e($Crypto->name_fa); ?> <?php echo e($Crypto->min_buy); ?> است.',
                            confirmButtonText: "تایید",
                        })
                         xhr.abort();
						 return false;
                    }

                    if ($('#amount').val()== '') {
                        Swal.fire({
                            icon: 'warning',
                            title: "توجه",
                            html: 'مقدار ارز مورد نیاز را درج کنید',
                            confirmButtonText: "تایید",
                        })
                         xhr.abort();
						return false;
                    }

                    if(parseInt($('#amount').val().replace(/\,/g, '')) > 50000000){
                        Swal.fire({
                            icon: 'warning',
                            title: "توجه",
                            html: 'شما نمی‌توانید بیش از ۵۰ میلیون تومان خرید داشته باشید.',
                            confirmButtonText: "تایید",
                        })
                         xhr.abort();
						return false;
                    }

                    if($("#buy_method:checked").val()==1 && $('#payment').html().replace(/\,/g, '') > <?php echo e(Auth::user()->wallet); ?>){
                        Swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: 'مبلغ قابل پرداخت از موجودی شما بیشتر است<br><small>برای پرداخت <a href="<?php echo e(asset('')); ?>wallet">کیف پول</a> خود را شارژ کنید<small>',
                            confirmButtonText: "تایید",
                        })
                         xhr.abort();
						return false;
                    }
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        location.href="<?php echo e(asset('').$Crypto->name); ?>/buy/"+data.id;
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })

                    }
                    unloading();
                }
            });
        });


    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/cripto/buy.blade.php ENDPATH**/ ?>