<?php $__env->startSection('title', 'اطلاعات کیف پول'); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-5">
            <div class="card border border-light">
                <div class="card-body">
                    <div class="card-title">ثبت آدرس کیف پول ارزی</div>
                    <div class="col-12 p-2 mb-2">
                        <form autocomplete="off" method="post" action=""  class="needs-validation" novalidate >
                            <?php echo csrf_field(); ?>
                            <div class="col-md-12 col-12 m-md-auto m-0 p-0 mt-2">
                                <div id="box-shaba" class="w-100" style="">
                                    <div class="col-md-9 form-group mx-auto">
                                        <label>نام ارز</label>
                                        <input type="text" class="form-control text-center ltr-dir" name="coin_name" placeholder="نام ارز" >
                                        <div class="invalid-feedback">نام ارز کیف پول را درج نمایید</div>
                                    </div>
                                    <div class="col-md-9 form-group mx-auto">
                                        <label>آدرس کیف پول</label>
                                        <input type="text" class="form-control text-center ltr-dir" name="wallet" placeholder="آدرس کیف پول" >
                                        <div class="invalid-feedback">آدرس کیف پول ارزی خود را درج کنید</div>
                                    </div>
                                </div>
                                <div class="text-center mt-3">
                                    <button type="submit" class="btn btn-primary btn-block">ثبت آدرس کیف پول</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-7">
            <div class="card ">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-default">
                            <tr>
                                <th class="text-center ">#</th>
                                <th class="text-center">نام ارز</th>
                                <th class="text-center">آدرس کیف پول</th>
                                <th class="text-center">وضعیت</th>
                            </tr>
                            </thead>
                            <tbody class="text-center font-size-small">
                            <?php $i=1 ?>
                            <?php if(count($wallet)>0): ?>
                                <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td scope="row" class="sans-serif"><?php echo e($i); ?></td>
                                        <td><?php echo e($wallet->coin_name); ?></td>
                                        <td class="text-11 sans-serif" ><?php echo e($wallet->wallet); ?></td>

                                        <?php if($wallet->confirm == 0): ?>
                                            <td><span class="badge bg-warning my-1 font-weight-light">منتظر تایید</span></td>
                                        <?php elseif($wallet->confirm == 1): ?>
                                            <td><span class="badge bg-success my-1 font-weight-light">تایید شده</span></td>
                                        <?php else: ?>
                                            <td><span class="badge bg-danger my-1 font-weight-light">تایید نشده</span></td>
                                        <?php endif; ?>

                                    </tr>
                                    <?php $i++ ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" scope="row">هیچ کیف پول ارزی ثبت نشده است</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>


        $(document).ready(function() {
            $('form').ajaxForm({
                beforeSend: function() {
                    ElementBlock('form button');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "خطا",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    ElementUnBlock('form button');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/profile/wallet.blade.php ENDPATH**/ ?>