<?php $__env->startSection('title', 'کاربران'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">کاربران</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">لیست کاربران</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>شناسه</th>
                            <th>نام و فامیل</th>
                            <th>کد ملی</th>
                            <th>موبایل</th>
                            <th>عضویت</th>
                            <th>موجودی</th>
                            <th>وضعیت</th>
                            <th>جزییات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td><?php echo e($user->name.' '.$user->family); ?></td>
                                <td><?php echo e($user->code_meli); ?></td>
                                <td><?php echo e($user->mobile); ?></td>
                                <td><?php echo e($user->created_at); ?></td>
                                <td><?php echo e(number_format($user->wallet)); ?></td>
                                <td>
                                    <?php if($user->auth_img_confirm == 1 & $user->selfie_img_confirm == 1): ?>
                                        <span class="badge badge-soft-success">تایید شده</span>
                                    <?php else: ?>
                                        <span class="badge badge-soft-warning">تایید نشده</span>
                                    <?php endif; ?>
                                </td>
                                <td><a class="btn btn-light" href="<?php echo e(asset('').env('PanelPrefix')); ?>/users/<?php echo e($user->id); ?>">مشاهده</a></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table><?php echo e($users->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/webcore-heydari/Downloads/arzland-v7/3.engine/arzland/resources/views/admin/users.blade.php ENDPATH**/ ?>