@extends('user.layouts.master')
@section('title', 'اطلاعات کیف پول')

@section('content')

    <div class="row">
        <div class="col-md-5">
            <div class="card border border-light">
                <div class="card-body">
                    <div class="card-title">ثبت آدرس کیف پول ارزی</div>
                    <div class="col-12 p-2 mb-2">
                        <form autocomplete="off" method="post" action=""  class="needs-validation" novalidate >
                            @csrf
                            <div class="col-md-12 col-12 m-md-auto m-0 p-0 mt-2">
                                <div id="box-shaba" class="w-100" style="">
                                    <div class="col-md-9 form-group mx-auto">
                                        <label>نام ارز</label>
                                        <input type="text" class="form-control text-center ltr-dir" name="coin_name" placeholder="نام ارز" >
                                        <div class="invalid-feedback">نام ارز کیف پول را درج نمایید</div>
                                    </div>
                                    <div class="col-md-9 form-group mx-auto">
                                        <label>آدرس کیف پول</label>
                                        <input type="text" class="form-control text-center ltr-dir" name="wallet" placeholder="آدرس کیف پول" >
                                        <div class="invalid-feedback">آدرس کیف پول ارزی خود را درج کنید</div>
                                    </div>
                                </div>
                                <div class="text-center mt-3">
                                    <button type="submit" class="btn btn-primary btn-block">ثبت آدرس کیف پول</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-7">
            <div class="card ">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-default">
                            <tr>
                                <th class="text-center ">#</th>
                                <th class="text-center">نام ارز</th>
                                <th class="text-center">آدرس کیف پول</th>
                                <th class="text-center">وضعیت</th>
                            </tr>
                            </thead>
                            <tbody class="text-center font-size-small">
                            @php $i=1 @endphp
                            @if(count($wallet)>0)
                                @foreach($wallet as $wallet)
                                    <tr>
                                        <td scope="row" class="sans-serif">{{$i}}</td>
                                        <td>{{$wallet->coin_name}}</td>
                                        <td class="text-11 sans-serif" >{{$wallet->wallet}}</td>

                                        @if($wallet->confirm == 0)
                                            <td><span class="badge bg-warning my-1 font-weight-light">منتظر تایید</span></td>
                                        @elseif($wallet->confirm == 1)
                                            <td><span class="badge bg-success my-1 font-weight-light">تایید شده</span></td>
                                        @else
                                            <td><span class="badge bg-danger my-1 font-weight-light">تایید نشده</span></td>
                                        @endif

                                    </tr>
                                    @php $i++ @endphp
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="6" scope="row">هیچ کیف پول ارزی ثبت نشده است</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>


@stop

@section('js')
@stop

@section('script')
    <script>


        $(document).ready(function() {
            $('form').ajaxForm({
                beforeSend: function() {
                    ElementBlock('form button');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "خطا",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    ElementUnBlock('form button');
                }
            });
        });
    </script>
@stop
