@extends('user.layouts.master')
@section('title', 'رمز عبور')
@section('css')

@stop

@section('content')
    <div class="row">
        <div class="col-xl-3">
            @include('user.profile.profile-detail')
        </div>
        <div class="col-xl-9">
            @include('user.profile.menu')

            <div class="alert alert-card alert-dark w-100 notification">
                <strong class="text-capitalize">توجه داشته باشید:</strong>
                برای افزایش امنیت سطح حساب کاربری خود می توانید، احراز هویت دو مرحله ای را <a href="{{asset('')}}profile/two-factor-authentication">اینجا</a> فعال کنید.
            </div>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-3">حساب کاربری</h4>
                    <p class="mt-2">
                        با استفاده از فرم زیر، میتوانید رمزعبور فعلی خود را جهت امنیت بیشتر تغییر دهید.<br>
                        سعی کنید کلمه عبور پیچیده ای انتخاب کنید و با سایر حساب های شما در سایت های دیگر یکسان نباشد.<br>
                        <br>
                    </p>
                    <form autocomplete="off" method="post" class="needs-validation" novalidate action="">
                        @csrf
                        <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-12 p-0 form-group mb-1">
                                <label>رمز عبور فعلی</label>
                                <input type="password" class="form-control text-center ltr-dir" minlength="6" id="old_password" name="old_password" placeholder="رمز فعلی" required>
                                <div class="invalid-feedback">رمز فعلی خود را درج کنید(حداقل 6 کاراکتر)</div>
                            </div>

                            <div class="col-md-12 p-0 form-group mb-1">
                                <label>رمز عبور جدید</label>
                                <input type="password" class="form-control text-center ltr-dir" minlength="6" id="password" name="password" placeholder="رمز جدید" required>
                                <div class="invalid-feedback">رمز جدید خود را درج کنید(حداقل 6 کاراکتر)</div>
                            </div>

                            <div class="col-md-12 p-0 form-group mb-1">
                                <label>تکرار رمز جدید</label>
                                <input type="password" class="form-control text-center ltr-dir" minlength="6" id="password_confirmation" name="password_confirmation" placeholder="تکرار رمز جدید" required>
                                <div class="invalid-feedback">تکرار رمز جدید خود را درج کنید(حداقل 6 کاراکتر)</div>
                            </div>
                            <div class="border-bottom w-80 mb-4 mt-2 mx-auto"></div>
                            <div class="col-md-12 m-auto mb-md-3 text-center">
                                <button type="submit" class="btn btn-primary">ثبت تغییرات</button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')

@stop

@section('script')
<script>
    $(document).ready(function () {

        $('form').ajaxForm({
            beforeSend: function (xhr, opts) {
                if ($('#new_password').val() != $('#renew_password').val()) {
                    swal.fire({
                        type: 'warning',
                        icon: 'warning',
                        title: "توجه",
                        html: 'پسورد های درج شده یکسان نیستند',
                        confirmButtonText: "تایید",
                    });
					xhr.abort();
                   return false
                }

                if ($('#password').val() == $('#new_password').val()) {
                    swal.fire({
                        type: 'warning',
                        icon: 'warning',
                        title: "توجه",
                        html: 'پسورد جدید با پسورد فعلی فرقی ندارد',
                        confirmButtonText: "تایید",
                    });
					xhr.abort();
                    return false
                }
            },
            complete: function (data) {
                data = data.responseJSON;
                if (data.status == true) {
                    swal.fire({
                        type: 'success',
                        icon: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                    }).then(function () {
                        location.reload();
                    });
                } else {
                    swal.fire({
                        type: 'warning',
                        icon: 'warning',
                        title: "توجه",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })

                }
            }
        });
    });
</script>
@stop
