@extends('user.layouts.master')
@section('title', 'تاریخچه ورود')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">تاریخچه ورود</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle table-nowrap table-hover">
                            <thead class="table-light">
                            <tr>
                                <th scope="col" style="width: 70px;">#</th>
                                <th scope="col">عنوان</th>
                                <th scope="col">آدرس تاریخچه</th>
                                <th scope="col">آی‌پی</th>
                                <th scope="col">مرورگر / سیستم‌عامل</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($logs as $key => $log)
                                <tr>
                                    <td><span>{{ ++$key }}</span></td>
                                    <td><span>{{ $log->subject }}</span></td>
                                    <td>{{ $log->url }}</td>
                                    <td class="text-warning">{{ $log->ip }}</td>
                                    <td>{{ $log->agent }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
