@extends('user.orders.single')

        @section('orders_model')
        <img src="{{asset('')}}app-assets/images/currency/skrill.svg" style="position: absolute;width: 13%;left: 20px;top: 20px;">
        <hr width="60%">
        <p>فهرست محصولات / خدمات درخواستی</p>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="">

                <tr>
                    <th class="text-center">#</th>
                    <th class="text-center w-60">شرح</th>
                    <th class="text-center">مقدار / تعداد</th>
                    <th class="text-center">قیمت واحد</th>
                    <th class="text-center">مبلغ کل</th>
                </tr>
                </thead>
                <tbody class="text-center">
                    <tr>
                        <td scope="row" class="sans-serif">1</td>
                        <td>{{$result->order->detail->type .' '. $result->order->detail->title}}</td>
                        <td>{{$result->order->detail->amount_dollar}}{{$result->order->detail->dollar}} </td>
                        <td>{{number_format($result->orders_model->price_dollar)}}</td>
                        <td>{{number_format($result->order->detail->amount_dollar * $result->orders_model->price_dollar)}}</td>
                    </tr>
                    @if($result->orders_model->type =='sell' && $result->orders_model->country !='آمریکا')
                    <tr>
                        <td scope="row" class="sans-serif">2</td>
                        <td>کسر 4.5% از مبلغ به عنوان کارمزد انتقال از کشور غیر از آمریکا</td>
                        <td>%4.5 </td>
                        <td>{{number_format($result->orders_model->price_dollar)}}</td>
                        <td>{{number_format($result->order->detail->amount_dollar * $result->orders_model->price_dollar - $result->orders_model->amount_rial)}} -</td>
                    </tr>
                    <tr>
                        <td class="border-0" colspan="4"></td>
                        <td colspan="4">{{number_format($result->orders_model->amount_rial)}}</td>
                    </tr>
                    @endif
                    <tr class="border-0">
                        <th class="border-0"></th>
                    </tr>
                    @if($result->orders_model->type =='charge')
                    <tr>
                        <td class="border-0"></td>
                        <th class="w-60">ایمیل گیرنده</th>
                        <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                            <i class="ft-copy"></i>  <span>{{$result->orders_model->email}}</span>
                        </td>
                    </tr>
                    @elseif($result->orders_model->type =='buy')
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">لینک محصول</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="ft-copy"></i>  <span>{{$result->orders_model->url_product}}</span>
                            </td>
                        </tr>
                        @if(isset($result->orders_model->username) && isset($result->orders_model->password) )
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">نام کاربری</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->username}}</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">رمز عبور</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->password}}</span>
                                </td>
                            </tr>
                        @endif
                    @else
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">ایمیل</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="ft-copy"></i>  <span>{{$result->orders_model->email}}</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">موقعیت حساب شما</th>
                            <td colspan="4" class="">
                                <span>{{$result->orders_model->country}}</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">صاحب حساب</th>
                            <td colspan="4" class="">
                                <span>{{$result->orders_model->account_owner}}</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">وضعیت حساب</th>
                            <td colspan="4" class="">
                                <span>{{$result->orders_model->account_status}}</span>
                            </td>
                        </tr>
                    @endif

                    @if(isset($result->order->payment_tracking))
                        <tr>
                            <td class="border-0"></td>
                            <th scope="row">کد پیگیری درگاه پرداخت</th>
                            <td colspan="4" class="sans-serif">
                                <span>{{$result->order->payment_tracking}}</span>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
        @stop
