@extends('user.layouts.master')
@section('title', 'جزئیات سفارش '.$result->order->detail->type .' '. $result->order->detail->title)
@section('css')
@stop

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">جزییات سفارش {{$result->order->detail->type .' '. $result->order->detail->title}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ asset('') }}orders">سفارشات</a></li>
                        <li class="breadcrumb-item active">فاکتور</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-lg-12">
            <div class="card border @if(strpos($result->order->status, 'معلق') !== false) border-dark @else border-warning @endif">
                <div class="card-body">
                    <div class="invoice-title">
                        <h4 class="float-end font-size-16">شماره سفارش # {{$result->order->id}}</h4>
                        <div class="mb-4">
                            <img src="{{ asset('images/logo/logo-dark.svg') }}" alt="logo" height="20"/>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                        <div class="col-sm-12">
                            <div class="my-2">
                                <strong>تاریخ ثبت:</strong>
                                {{$result->order->date}}
                            </div>
                            <div class="my-2">
                                <strong>مبلغ سفارش:</strong>
                                {{number_format($result->order->amount)}} تومان
                            </div>
                            <div class="my-2">
                                <strong>وضعیت:</strong>
                                @if(strpos($result->order->status, 'معلق') !== false)
                                    <span class="badge bg-dark">معلق</span>
                                    <span class="badge bg-success">{{substr($result->order->status, strpos($result->order->status, ",") + 1)}}</span>
                                @elseif($result->order->status == 'نا موفق,پرداخت شده')
                                    <span class="badge bg-success">پرداخت شده</span>
                                    <span class="badge bg-danger">ناموفق </span>
                                @else
                                    <span class="badge bg-success">{{$result->order->status}}</span>
                                    <span class="badge bg-danger">ناموفق </span>
                                @endif
                            </div>
                            @if($result->order->type == 'sell')
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    @if(isset($result->order->id_cardbank))
                                        شماره کارت  <span dir="ltr">{{substr_replace($result->order->cardbank->card_number, str_repeat("*", 6), 6, 6)}}</span>
                                    @else
                                        کیف پول شما در {{ getSetting('app_name_farsi') }}
                                    @endif
                                </div>
                            @else
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    {{$result->order->payment_gateway}}
                                </div>
                            @endif
                            @if(isset($result->order->description))
                                <div class="my-2">
                                    <strong>توضیحات سفارش:</strong>
                                    {{$result->order->description}}
                                </div>
                            @endif
                            @if(isset($result->ticket))
                                @if($result->ticket->seen_admin == 1)
                                    <div class="alert alert-card alert-blue" role="alert">
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است و جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="amber"><i class="ft-link"></i> لینک تیکت </a>
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">×</span>
                                        </button>
                                    </div>
                                @else
                                    <div class="alert alert-card alert-warning" role="alert">
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است که هنوز ندیده اید و لطفا جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="typo_link text-primary"><i class="ft-link"></i> لینک تیکت </a>
                                    </div>
                                @endif
                            @endif
                            <div class="my-4">
                                <span class="mb-3">مشخصات خریدار:</span>
                                <div class="table-responsive">
                                    <table class="table align-middle table-nowrap table-hover">
                                        <thead class="table-light">
                                        <tr>
                                            <th scope="col" style="width: 70px;">#</th>
                                            <th scope="col">نام و نام خانوادگی</th>
                                            <th scope="col">شماره تماس</th>
                                            <th scope="col">ایمیل</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <div class="avatar-xs">
                                                    <img src="{{ asset('images/users/user.png') }}" width="30px">
                                                </div>
                                            </td>
                                            <td>
                                                <h5 class="font-size-14 mb-1">{{$result->user->name .' '.$result->user->family}}</h5>
                                            </td>
                                            <td>{{$result->user->mobile}}</td>
                                            <td>{{$result->user->email??'ثبت نشده است'}}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-2 mt-3">
                        <h3 class="font-size-15 fw-bold">جزئیات سفارش</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-nowrap">
                            <thead>
                            <tr>
                                <th style="width: 70px;">#</th>
                                <th>عنوان سفارش</th>
                                <th class="text-end">قیمت</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>01</td>
                                <td>{{$result->order->detail->type .' '. $result->order->detail->title}}</td>
                                <td class="text-end">{{number_format($result->order->amount)}} تومان</td>
                            </tr>
                            <tr>
                                <td colspan="2" class="border-0 text-end">
                                    <strong>مجموع</strong></td>
                                <td class="border-0 text-end"><h4 class="m-0">{{number_format($result->order->amount)}} تومان</h4></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                        <div>
                            @if($result->order->status =='معلق,پرداخت شده')
                                <h5 class="text-center m-auto col-md-8 text-dark">
                                    سفارش شما بعلت پرداخت با کارت غیر از کارت های تایید شده در وضعیت معلق و پرداخت شده میباشد و تیکتی به صورت اتوماتیک برای شما جهت این سفارش ایجاد شده است و از طریق تیکت مبلغ پرداختی خود را پیگیری کنید!
                                </h5>
                            @elseif($result->order->status =='معلق,عودت')
                                <h5 class="text-center m-auto col-md-8 text-dark">
                                    سفارش شما بعلت پرداخت با کارت غیر از کارت های تایید شده در وضعیت معلق و پرداخت شده بود که تیکتی به صورت اتوماتیک برای شما جهت این سفارش ایجاد شده و اکنون <b>مبلغ این سفارش به شما عودت داده شد!</b>
                                </h5>
                            @else
                                @if(isset($result->BackStock))
                                    <h5 class="text-center m-auto col-md-8 text-danger">
                                        این سفارش پرداخت شده است اما ثبت سفارش با موفقیت انجام نشده و همچنین مبلغ این سفارش به کیف پول شما انتقال یافته است.
                                    </h5>
                                @else
                                    <h5 class="text-center m-auto col-md-8 text-danger">
                                        این سفارش پرداخت شده است اما ثبت سفارش با موفقیت انجام نشده و همچنین جهت پیگیری مبلغ پرداختی میتوانید با پشتیبانی در تماس باشید.
                                    </h5>
                                @endif
                                <h5 class="text-center mt-3">موجودی فعلی کیف پول: {{number_format(Auth::user()->wallet)}} تومان </h5>
                            @endif
                        </div>
                    </div>
                    <div class="d-print-none">
                        <div class="float-end">
                            <a href="javascript:window.print()" class="btn btn-success waves-effect waves-light me-1"><i class="fa fa-print"></i></a>
                            <a href="{{ asset('') }}orders" class="btn btn-light w-md waves-effect waves-light">بازگشت به سفارشات</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop



