@extends('user.layouts.master')
@section('title', 'سفارشات')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارشات</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{asset('')}}">داشبورد</a></li>
                        <li class="breadcrumb-item active">سفارشات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-4">
                        <div class="card-title mb-0">لیست سفارشات شما</div>
                    </div>
                    <div class="col-md-12">
                        <div class="row justify-content-between">
                            <div class="col-md-3">
                                <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                            </div>
                            <div class="col-md-3 d-flex">
                                <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-nowrap" id="myTable">
                            <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>ارز</th>
                                <th>نوع سفارش</th>
                                <th>مقدار</th>
                                <th>تاریخ و ساعت ثبت</th>
                                <th>وضعیت</th>
                                <th>مبلغ سفارش</th>
                                <th>جزئیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 1; @endphp
                            @foreach($orders as $order)
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>
                                        <img class="me-1" src="{{asset('')}}app-assets/images/currency/{{ $order->orders_model }}.svg" width="25px">
                                        {{ $order->orders_model }}
                                    </td>
                                    <td>
                                        @if($order->type == 'sell')
                                            فروش
                                        @elseif($order->type == 'buy')
                                            خرید
                                        @endif
                                    </td>
                                    <td>{{ $order->amount_coin }}</td>
                                    <td>{{ $order->created_at }}</td>
                                    <td>{{ $order->status }}</td>
                                    <td>{{ $order->amount }} <small>تومان</small></td>
                                    <td><a class="btn btn-light btn-sm" href="{{ asset('') }}orders/{{ $order->id }}"><small>مشاهده سفارش</small></a></td>
                                </tr>
                                @php $i++ @endphp
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
