@extends('user.layouts.master')
@section('title', 'سفارشات باز')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارشات باز</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{asset('')}}">داشبورد</a></li>
                        <li class="breadcrumb-item active">سفارشات-باز</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-rep-plugin">
                        <div class="table-responsive mb-0" data-pattern="priority-columns">
                            <table id="tech-companies-1" class="table table-striped">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th data-priority="1">ارز</th>
                                    <th data-priority="3">نوع سفارش</th>
                                    <th data-priority="1">مقدار</th>
                                    <th data-priority="3">تاریخ و ساعت ثبت</th>
                                    <th data-priority="3">وضعیت</th>
                                    <th data-priority="6">مبلغ سفارش</th>
                                    <th data-priority="6">جزئیات</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php $i = 1; @endphp
                                @foreach($orders as $order)
                                    <tr>
                                        <td>{{$i}}</td>
                                        <th>
                                            <img class="me-1" src="{{asset('')}}app-assets/images/currency/{{$order->orders_model}}.svg" width="25px">
                                            {{$order->orders_model}}
                                        </th>
                                        <th>
                                            @if($order->type == 'sell')
                                                خرید
                                            @elseif($order->type == 'buy')
                                                فروش
                                            @endif
                                        </th>
                                        <th>{{$order->amount_coin}}</th>
                                        <th>{{$order->created_at}}</th>
                                        <th>
                                            @if($order->status == 'پرداخت شده')
                                                <span class="badge badge-soft-success">پرداخت شده</span>
                                            @elseif($order->status == 'پرداخت شده')
                                            @endif
                                        </th>
                                        <th>{{$order->amount}} <small>تومان</small></th>
                                        <th><a class="btn btn-primary btn-sm" href="{{ asset('') }}orders/{{$order->id}}"><small>مشاهده سفارش</small></a></th>
                                    </tr>
                                    @php $i++ @endphp
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
@stop
