<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<!-- BEGIN: Head-->
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="">
    <meta name="_token" content="{{ csrf_token() }}">
    <title>@yield('title')</title>
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('images/logo/SVGFLAT.svg')}}">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="{{ asset('css/bootstrap-rtl.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ asset('libs/toastr.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="{{ asset('css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="{{ asset('css/app-rtl.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    <!-- Fonts Css-->
    <link href="{{ asset('css/font_iransans.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    @yield('head')
</head>

<body style="font-family: IRANSans !important;">
    <header>
        <div class="bg-white">
            <div class="container py-3 d-flex justify-content-between">
                <div class="my-auto">
                    <img src="{{ asset('images/logo/logo-dark.svg') }}" width="100rem" alt="">
                </div>
                <div class="my-auto">
                    <a href="" class="btn btn-light text-dark">ورود به پرتال اصلی</a>
                </div>
            </div>
        </div>
    </header>
    <div class="account-pages my-5 pt-sm-5">
        <div class="container">
            @yield('content')
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="{{ asset('js/jquery.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/bootstrap.bundle.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/metisMenu.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/simplebar.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/waves.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/sweetalert2.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/jquery.form.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('libs/jquery.blockUI.js') }}"></script>
    <script src="{{ asset('libs/toastr.min.js') }}"></script>

    <!-- App js -->
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('js/arzland.js') }}"></script>

    @yield('js')
    @yield('script')
    {!! NoCaptcha::renderJs() !!}

    @if(Session::has('Success'))
        <script>
            if(!$(".alert-card").length)
                toastr.success("{{ Session::get('Success') }}", "انجام شد!", {
                    positionClass: "toast-top-center",
                    progressBar: !0,
                    timeOut:6000,closeButton:!0
                })
        </script>
    @endif
    @if(Session::has('Error'))
        <script>
            if(!$(".alert-card").length)
                toastr.error("{{ Session::get('Error') }}", "خطا!", {
                    positionClass: "toast-top-center",
                    progressBar: !0,
                    timeOut:10000,closeButton:!0
                })
        </script>
    @endif
    @if(Session::has('Info'))
        <script>
            if(!$(".alert-card").length)
                toastr.info("{{ Session::get('Info') }}", "در دست بررسی!", {
                    positionClass: "toast-top-center",
                    opacity:1,
                    progressBar: !0,
                    timeOut:6000,closeButton:!0
                })
        </script>
    @endif

</body>
</html>
