@extends('user.layouts.master')
@section('title', ' پنل کاربری '.getSetting('app_name_farsi'))

@section('content')
    <div class="row">
        <div class="alert alert-dark alert-dismissible fade show" role="alert">
            <strong class="text-capitalize">دسترسی:</strong>
            لطفا جهت دریافت تخفیف ها و اطلاعیه های سایت به این سایت اجازه دسترسی به نوتیفکیشن را بدهید!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @foreach($result->notification as $Notif)
            @if($Notif->head_fix == 1)
                <div class="alert alert-{{($Notif->color!='' ? $Notif->color : 'primary')}} alert-dismissible fade show" role="alert">
                    <strong class="text-capitalize">{{$Notif->title}}:</strong> {{$Notif->message}}
                </div>
            @elseif($Notif->head_close == 1)
                <div class="alert alert-{{($Notif->color!='' ? $Notif->color : 'primary')}} alert-dismissible fade show" role="alert">
                    <strong class="text-capitalize">{{$Notif->title}}:</strong> {{$Notif->message}}
                    <button type="button" class="btn-close" onclick="RemoveNotification({{$Notif->id}})" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
        @endforeach
    </div>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">داشبورد</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="float-end dropdown ms-2">
                        <a class="text-muted dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="mdi mdi-dots-horizontal font-size-18"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a class="dropdown-item" href="{{asset('')}}profile">پروفایل</a>
                            <a class="dropdown-item" href="{{asset('')}}profile/password">کلمه عبور</a>
                            <a class="dropdown-item" href="{{asset('')}}profile/two-factor-authentication">ورود دو مرحله‌ای</a>
                        </div>
                    </div>
                    <div>
                        <div class="mb-4 me-3">
                            <img src="{{ asset('images/users/user.png') }}" width="35px">
                        </div>
                        <div>
                            <h5>{{Auth::user()->name .' '.Auth::user()->family }}</h5>
                            <p class="text-muted mb-2">{{Auth::user()->email??'ایمیل خود را وارد نکردید'}}</p>
                            <p class="text-muted mb-0">{{Auth::user()->mobile}}</p>
                        </div>
                    </div>
                </div>

                <div class="card-body border-top">
                    <div class="row">
                        <div class="col-sm-6">
                            <div>
                                <p class="fw-medium mb-2">موجودی ریالی</p>
                                <h4>{{number_format(Auth::user()->wallet)}} <small>تومان</small></h4>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer bg-transparent border-top">
                    <div class="text-center">
                        <a href="{{ asset('') }}history/orders" class="btn btn-outline-light me-2 w-md">سفارشات من</a>
                        <a href="{{ asset('') }}ticket" class="btn btn-light me-2 w-md">پشتیبانی</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-8">
            <div class="card border border-warning">
                <div class="row">
                    <div class="col-lg-9 col-sm-8">
                        <div  class="p-4">
                            <h5 class="text-primary mb-2">خوش آمدید</h5>
                            <p>وضعیت حساب کاربری شما:</p>

                            <div class="text-muted">
                                <a class="text-dark d-flex" href="{{asset('')}}profile">
                                    <p class="mb-1"><i class="mdi mdi-circle-medium align-middle text-primary me-1"></i> تصویر کارت ملی و مدارک</p>
                                    <div class="w-50 text-right ms-2">
                                        @if(Auth::user()->auth_img_confirm ==1)
                                            <div class="badge bg-success">تایید شده</div>
                                        @elseif(Auth::user()->auth_img_confirm == 0)
                                            <div class="badge bg-primary">تایید نشده</div>
                                        @elseif(Auth::user()->auth_img_confirm == 2)
                                            <div class="badge bg-warning">انتظار بررسی</div>
                                        @else
                                            <div class="badge bg-danger">رد شده</div>
                                        @endif
                                    </div>
                                </a>
                                <a class="text-dark d-flex" href="{{asset('')}}profile">
                                    <p class="mb-1"><i class="mdi mdi-circle-medium align-middle text-primary me-1"></i> تصویر سلفی</p>
                                    <div class="w-50 text-right ms-2">
                                        @if(Auth::user()->selfie_img_confirm ==1)
                                            <div class="badge bg-success">تایید شده</div>
                                        @elseif(Auth::user()->selfie_img_confirm == 0)
                                            <div class="badge bg-primary">تایید نشده</div>
                                        @elseif(Auth::user()->selfie_img_confirm == 2)
                                            <div class="badge bg-warning">انتظار بررسی</div>
                                        @else
                                            <div class="badge bg-danger">رد شده</div>
                                        @endif
                                    </div>
                                </a>
                                <a class="text-dark d-flex" href="{{asset('')}}profile">
                                    <p class="mb-0"><i class="mdi mdi-circle-medium align-middle text-primary me-1"></i> کارت بانکی</p>
                                    <div class="w-50 text-right ms-2">
                                        @if($result->cardbank > 0)
                                            <div class="badge bg-success">تایید شده</div>
                                        @else
                                            <div class="badge bg-primary">تایید نشده</div>
                                        @endif
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-4 align-self-center">
                        <div>
                            <img src="{{ asset('images/crypto/features-img/img-1.png') }}" alt="" class="img-fluid d-block">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="avatar-xs me-3">
                                    <span class="avatar-title rounded-circle bg-primary bg-soft text-primary font-size-18">
                                        <i class="bx bx-copy-alt"></i>
                                    </span>
                                </div>
                                <h5 class="font-size-14 mb-0">تعداد خریدها</h5>
                            </div>
                            <div class="text-muted mt-4">
                                <h4>{{ $result->CountBuy }} <i class="mdi mdi-chevron-up ms-1 text-success"></i></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="avatar-xs me-3">
                                    <span class="avatar-title rounded-circle bg-primary bg-soft text-primary font-size-18">
                                        <i class="bx bx-copy-alt"></i>
                                    </span>
                                </div>
                                <h5 class="font-size-14 mb-0">تعداد فروش ها</h5>
                            </div>
                            <div class="text-muted mt-4">
                                <h4>{{ $result->CountSell }} <i class="mdi mdi-chevron-down ms-1 text-danger"></i></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <div class="avatar-xs me-3">
                                    <span class="avatar-title rounded-circle bg-primary bg-soft text-primary font-size-18">
                                        <i class="bx bx-copy-alt"></i>
                                    </span>
                                </div>
                                <h5 class="font-size-14 mb-0">مبلغ کل تراکنش ها</h5>
                            </div>
                            <div class="text-muted mt-4">
                                <h4>{{ number_format( $result->TotalAmount ) }} <small>تومان</small></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="card" id="coinCalculator">
                <div class="card-body">
                    <h4 class="card-title">ماشین حساب</h4>
                    <p class="card-title-desc">توسط ابزار زیر می توانید قیمت ارزها را محاسبه کنید و سپس نسبت به خرید آن اقدام نمایید.</p>
                    <ul class="nav nav-pills nav-justified" role="tablist">
                        <li class="nav-item waves-effect waves-light bg-light">
                            <a class="nav-link active" data-bs-toggle="tab" href="#home-1" role="tab" v-on:click="onChangeTradeMode(true)">
                                <span>محاسبه خرید</span>
                            </a>
                        </li>
                        <li class="nav-item waves-effect waves-light bg-light">
                            <a class="nav-link" data-bs-toggle="tab" href="#profile-1" role="tab" v-on:click="onChangeTradeMode(false)">
                                <span>محاسبه فروش</span>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content p-3 text-muted">
                        <div class="tab-pane active" id="home-1" role="tabpanel">
                            <div class="form-group mt-3">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                    </div>
                                    <input class="form-control" id="coin1" placeholder="مقداری که قصد خرید دارید " type="text"
                                           v-model="tradeVolume" maxlength="7">
                                    <div class="dropdown input-group-append">
                                        <button aria-expanded="false" aria-haspopup="true" class="btn btn-sm btn-primary dropdown-toggle arrow-bottom" data-bs-toggle="dropdown" type="button">
                                            <img v-bind:src="'{{asset('')}}app-assets/images/currency/'+ selectedCoin.logo.toLowerCase() +'.svg'" width="35px"> @{{selectedCoin.abbr}}
                                        </button>
                                        <div class="dropdown-menu text-right coin-menu" style="height: 250px;overflow: auto">
                                            <span class="dropdown-item" v-for="(item, index) in selectableCoins" v-on:click="onSelectCoin(item)" style="cursor: pointer;">
                                               <img v-bind:src="'{{asset('')}}app-assets/images/currency/'+ item.logo.toLowerCase() +'.svg'" width="25px"> @{{item.name}}
                                          </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                    </div>
                                    <input class="form-control" id="coin2" placeholder="مبلغی که میپردازید " type="text" v-bind:value="tradeVolume ? result : 'مبلغی که میپردازید '" disabled>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <img v-bind:src="'{{asset('')}}app-assets/images/currency/iran.svg'" width="35px"> تومان
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <form action="{{asset('')}}dashboard/redirect" method="post" name="frm" id="frm">
                                @csrf
                                <input type="hidden" name="coin" id="coin" :value="selectedCoin.name">
                                <input type="hidden" name="type" id="type" :value="isBuyMode">
                                <input type="hidden" v-bind:value="tradeVolume ? result : 'مبلغی که میپردازید '" name="amount" id="amount">
                                <button type="submit" class="btn btn-outline-secondary btn-block py-2 text-14" >ادامه فرآیند خرید</button>
                            </form>
                        </div>
                        <div class="tab-pane" id="profile-1" role="tabpanel">
{{--                            <div class="d-flex flex-column ltr-dir">--}}
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                        </div>
                                        <input class="form-control" placeholder="مقداری که قصد فروش دارید " type="text"
                                               v-model="tradeVolume" maxlength="7">
                                        <div class="dropdown input-group-append">
                                            <button aria-expanded="false" aria-haspopup="true" class="btn btn-sm btn-primary dropdown-toggle arrow-bottom" data-bs-toggle="dropdown" type="button">
                                                <img v-bind:src="'{{asset('')}}app-assets/images/currency/'+ selectedCoin.logo.toLowerCase() +'.svg'" width="35px"> @{{selectedCoin.abbr}}
                                            </button>
                                            <div class="dropdown-menu text-right">
                                                <span class="dropdown-item" v-for="(item, index) in selectableCoins" v-on:click="onSelectCoin(item)" style="cursor: pointer;">
                                                    <img v-bind:src="'{{asset('')}}app-assets/images/currency/'+ item.logo.toLowerCase() +'.svg'" width="25px"> @{{item.name}}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                        </div>
                                        <input class="form-control" placeholder="مبلغی که دریافت میکنید " type="text" v-bind:value="tradeVolume ? result : 'مبلغی که دریافت میکنید '" disabled>
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <img v-bind:src="'{{asset('')}}app-assets/images/currency/iran.svg'" width="35px"> تومان
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-outline-secondary btn-block py-3" onclick="$('#frm').submit()">ادامه فرآیند فروش</button>
                            </div>
{{--                        </div>--}}
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">اطلاعات ارزها</h4>
                    <p class="card-title-desc">اطلاعات هر ارز به همراه قیمت خرید و فروش آن در سایت را مشاهده میکنید</p>
                    <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner" role="listbox">
                            @php $i = 0; $j = rand(0,1)@endphp
                            @foreach($result->Currencys as $Currency)
                                <div class="carousel-item @if($i==$j)active @endif">
                                    <div class="text-center">
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <img class="rounded-circle avatar-sm" src="{{asset('')}}app-assets/images/currency/{{strtolower($Currency)}}.svg" alt="{{ $Currency }}">
                                            </div>
                                            <h5 class="font-size-15 mb-1"><a href="javascript: void(0);" class="text-dark">{{ $Currency }}</a></h5>
                                        </div>
                                        <div class="card-footer bg-transparent border-top">
                                            <div class="text-center">
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <div class="mt-4 mt-sm-0">
                                                            <div class="font-size-24 text-primary mb-2"><i class="bx bx-import"></i></div>
                                                            <p class="text-muted mb-2">قیمت خرید</p>
                                                            <h5 class="m-0 font-weight-bold text-muted"
                                                                id="fee_buy_{{($Currency)}}">
                                                                <div class="font-medium-1 spinner-border spinner-border-sm"></div>
                                                            </h5>
                                                            <div class="mt-3">
                                                                <a href="{{ asset('') }}{{ $Currency }}" class="btn btn-primary btn-sm w-md">خرید</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <div class="font-size-24 text-primary mb-2"><i class="bx bx-send"></i></div>
                                                            <p class="text-muted mb-2">قیمت فروش</p>
                                                            <h5 class="m-0 font-weight-bold text-muted"
                                                                id="fee_sell_{{($Currency)}}">
                                                                <div class="font-medium-1 spinner-border spinner-border-sm"></div>
                                                            </h5>
                                                            <div class="mt-3">
                                                                <a href="{{ asset('') }}{{ $Currency }}/sell" class="btn btn-primary btn-sm w-md">فروش</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @php $i++; @endphp
                            @endforeach
                        </div>
                        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">قبلی</span>
                        </a>
                        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">بعدی</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-headset h2 text-warning mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">تیکت ها</p>
                            <h5 class="mb-0">{{$result->CountTicket}}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-account-plus-outline h2 text-primary mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">معرفی ها</p>
                            <h5 class="mb-0">{{ $result->CountInvitation }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-shopping-outline h2 text-warning mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">جمع خرید روزانه</p>
                            <h5 class="mb-0">{{number_format($result->SumOrderDay )}}<span class="font-small-1">تومان</span></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-align-vertical-top h2 text-success mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">باقیمانده سقف خرید امروز</p>
                            <h5 class="mb-0">{{ number_format(Auth::user()->daily_buy - $result->SumOrderDay) }}<span class="font-small-1"> تومان</span></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">اطلاعیه‌ها</h4>
                    <ul class="list-group" data-simplebar style="max-height: 390px;">
                        @foreach($result->notification as $Notif)
                            @if($Notif->notification == 1)
                                <li class="list-group-item border-0">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="avatar-xs">
                                    <span class="rounded-circle">
                                        <img src="{{ asset('images/notification.svg') }}" alt="" height="30">
                                    </span>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h5 class="font-size-14">{{ $Notif->title }}</h5>
                                            <p class="text-muted">{{ $Notif->message }}</p>

                                            <div class="float-end">
                                                <p class="text-muted mb-0"><i class="mdi mdi-account me-1"></i> مدیریت</p>
                                            </div>
                                            <p class="text-muted mb-0">{{ $Notif->created_at }}</p>
                                        </div>
                                    </div>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{ asset('js/vue.min.js') }}"></script>
    <script src="{{asset('')}}app-assets/vendors/js/charts/chart.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/bootstrap-select.js"></script>
    <script src="{{asset('')}}app-assets/vendors/js/digitbox.min.js"></script>

@stop

@section('script')

    <script>
        const vm1 = new Vue({
            el: '#coinCalculator',
            data: {
                tradeVolume: '1',
                selectableCoins: [
                    @foreach(\App\Cryptocurrency::get() as $row)
                    { name: '{{ $row->name }}', logo: '{{ $row->name }}', abbr: '{{ $row->symbol }}', id: {{ $row->id }} },
                    @endforeach
                ],
                serverCoinsPrice: {},
                isLoading: true,
                selectedCoin: { name: 'bitcoin', logo: 'bitcoin', abbr: 'btc', id: 1 },
                selectedCoinPriceSell: 0,
                selectedCoinPriceBuy: 0,
                isBuyMode: true,
                result: null
            },
            methods: {
                onSelectCoin: function (coin) {
                    this.selectedCoin = coin;
                    this.selectedCoinPriceSell = this.serverCoinsPrice['fee_sell_'+coin.logo].replace(/\,/g, '')
                    this.selectedCoinPriceBuy = this.serverCoinsPrice['fee_buy_'+coin.logo].replace(/\,/g, '')
                    this.calculateResult(this.tradeVolume);
                },
                onChangeTradeMode(mode) {
                    this.isBuyMode = mode;
                    this.calculateResult(this.tradeVolume);
                },
                getCoinsPrice() {
                    fetch('{{asset('')}}stock',
                        {
                            method: 'POST',
                            mode: 'cors',
                            cache: 'no-cache',
                            headers: {
                                'Content-Type': 'application/json',
                                'Connection': 'keep-alive',
                            },
                            body: JSON.stringify({_token: "{{ csrf_token() }}"})
                        }
                    )
                        .then(res => {
                            return res.json()
                        })
                        .then(data => {
                            this.serverCoinsPrice = data;
                            this.onSelectCoin(this.selectedCoin);
                            this.isLoading = false;
                            $.each(data, function (k, v) {
                                $('#' + k).html(v),
                                    $('#' + k).show();
                            });
                        });
                },
                calculateResult(tradeVolume) {
                    if (tradeVolume) {
                        const val = parseFloat(tradeVolume);
                        //alert(this.selectedCoinPriceSell);
                        if (val.toString() !== 'NaN') {
                            if (this.isBuyMode === true) {
                                this.result = (Math.round(this.selectedCoinPriceBuy * val)).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                            } else {
                                this.result = (Math.round(this.selectedCoinPriceSell * val)).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                            }
                        } else {
                            this.result = 'لطفا عدد وارد نمایید'
                        }
                    }
                }
            },
            watch: {
                tradeVolume: function (value) {
                    this.calculateResult(value);
                }
            },
            mounted() {
                this.getCoinsPrice();
                //setTimeout(() => { this.getCoinsPrice() }, 2000)
                $('#coin1,#coin2').digitbox({float:true});
            }
        })



        $(window).on("load", function () {
            var a = $("#polar-chart");
            new Chart(a, {
                type: "pie",
                options: {
                    legend: {
                        position: "left",
                        labels: {
                            fontSize: 14,
                            fontFamily: 'Vazir-FD',
                        }
                    },
                    tooltips: {
                        titleFontFamily: 'Vazir-FD',
                        bodyFontFamily: 'Vazir-FD',
                        titleMarginBottom: 10,
                        titleSpacing: 10,
                        callbacks: {
                            label: function(tooltipItem, data) {
                                var value = data.datasets[0].data[tooltipItem.index];
                                var str = data.labels[tooltipItem.index];
                                if(parseInt(value) >= 1000){
                                    return str + ' ' + value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                } else {
                                    return str + ' ' + value;
                                }
                            }
                        } // end callbacks:

                    },
                    responsive: !0, maintainAspectRatio: !1, responsiveAnimationDuration: 500},
                data: {
                    labels: ["میزان خرید های امروز", "میزان باقیمانده"],
                    datasets: [{
                        label: "مجموعه داده اول من",
                        data: [{{$result->SumOrderDay}}, {{Auth::user()->daily_buy - $result->SumOrderDay}}],
                        backgroundColor: ["#666EE8", "#28D094"]
                    }]
                }
            })
        });


        if (Notification.permission !== "granted" && 1 == {{number_format(Auth::user()->requestPermission)}}) {
            $('.notification').show();
            Notification.requestPermission();
        }
    </script>

@stop
