@extends('user.layouts.master')
@section('title', 'فروش '.$Crypto->name_fa)
@section('css')
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">فروش {{$Crypto->name_fa}}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ asset('') }}wallet">بازار ارزهای دیجیتال</a></li>
                        <li class="breadcrumb-item active">فروش {{$Crypto->name_fa}}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3">
                            <img src="{{asset('')}}app-assets/images/currency/{{$Crypto->name}}.svg" alt="" class="avatar-md rounded-circle img-thumbnail">
                        </div>
                        <div class="flex-grow-1 align-self-center">
                            <div class="text-muted">
                                <h5>{{$Crypto->name_fa}}</h5>
                                <p class="mb-1">{{$Crypto->symbol}}</p>
                            </div>
                        </div>
                        <div class="dropdown">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-wallet me-1"></i> <span class="d-none d-sm-inline-block">کیف پول ریالی <i class="mdi mdi-chevron-down"></i></span></button>
                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-md">
                                <div class="dropdown-item-text">
                                    <div>
                                        <p class="text-muted mb-2">موجودی در دسترس</p>
                                        <h5 class="mb-0">{{number_format(Auth::user()->wallet)}}</h5>
                                    </div>
                                </div>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item text-primary text-center" href="{{ asset('') }}wallet" target="_blank">
                                    شارژ کیف پول
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row" id="coinCalculator">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="mt-4">
                        <ul class="nav nav-pills bg-light rounded" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link" href="{{ asset('') }}{{$Crypto->name}}">خرید</a>
                            </li>
                            <li class="nav-item">
                                <a class="btn btn-danger text-white" href="{{ asset('') }}{{$Crypto->name}}/sell">فروش</a>
                            </li>
                        </ul>
                        <div class="tab-content mt-4">
                            <div id="buy-tab">
                                <div>
                                    <div class="row mb-3">
                                        <div class="text-center">
                                            <div class="d-flex">
                                                <div class="flex-grow-1">
                                                    <p class="text-muted mb-2">هر یک {{$Crypto->name_fa}}</p>
                                                    <h6>
                                                        @{{ fee }}
                                                        <span class="spinner-grow text-primary" v-if="isLoading" role="status" style="height: 17px;width: 17px"></span> تومان
                                                    </h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div>
                                        <form id="coin_sell" class="mt-2 needs-validation" novalidate action="" autocomplete="off" method="post">
                                            @csrf
                                            @if(Auth::user()->auth_img_confirm != 1 || Auth::user()->selfie_img_confirm != 1)
                                                <div class="card border border-danger">
                                                    <div class="card-header bg-transparent border-danger">
                                                        <span class="my-0 text-danger"><i class="mdi mdi-alert me-3"></i>احراز هویت شما کامل نشده!</span>
                                                    </div>
                                                </div>
                                            @else
                                                <label>مقدار {{$Crypto->name_fa}}</label>
                                                <div class="input-group mb-3">
                                                    <label class="input-group-text">
                                                        <img src="{{asset('')}}app-assets/images/currency/{{$Crypto->name}}.svg" alt="{{$Crypto->symbol}}" width="20px">
                                                    </label>
                                                    <input id="coin" name="coin" maxlength="10" autocomplete="off"
                                                           v-on:keyup="calculateResult('coin')" v-model="coin"
                                                           class="form-control text-center">
                                                    <label class="input-group-text">{{$Crypto->symbol}}</label>
                                                </div>
                                                <div class="col-md-12 p-0 form-group mb-2">
                                                    <label for="firstName1">کیف پول {{ getSetting('app_name_farsi') }}</label>
                                                     @php
                                                      // echo $result->address[0]['addressId'];
                                                     @endphp
                                                    <input type="text" readonly
                                                    id="addressValue"
                                                           class="form-control text-center text-primary"
                                                          value="{{$result['address_id']}}" data-toggle="tooltip" data-title="کپی در حافظه" onclick="copyToClipboard()">

                                                    <input type="text" readonly
                                                    id="networkName"
                                                    type="text"
                                                    style="display: none;"
                                                          value="{{$network}}">




                                                    <ul class="nav nav-pills nav-justified mb-2 bg-light" role="tablist">
                                                    @php
                                                        $i = 0;
                                                    @endphp
                                                    @if(count($result) > 1)
                                                    @foreach($result as $key => $item)
                                                    <li class="nav-item waves-effect waves-light" onclick="document.getElementById('addressValue').value='{{$result['address_id']}}';document.getElementById('tagValue').value='{{$result['addressTag']}}';document.getElementById('networkName').value='{{$network}}'" v-on:click="network_name = '{{ $network }}';">
                                                        <a class="nav-link nav-link-x {{ $i == 0 ? 'active' : '' }}" data-bs-toggle="tab" href="" role="tab">
                                                            <span>{{ $network }}</span>
                                                        </a>
                                                    </li>
                                                    @php
                                                    $i++;
                                                    @endphp
                                                    @endforeach
                                                    @endif
                                                </ul>
                                                </div>


                                                    <div class="col-md-12 p-0 form-group mb-2 tag-section">
                                                        <label for="firstName1">تگ آدرس کیف پول {{ getSetting('app_name_farsi') }}</label>
                                                        <input type="text" readonly
                                                        id="tagValue"
                                                               class="form-control text-center text-primary"
                                                               value="{{$result['addressTag']}}" data-toggle="tooltip" data-title="کپی در حافظه" onclick="copyToClipboard(this)">
                                                    </div>
                                                <p class="mt-0" style="display: none" id="note">مقدار <span class="text-primary font-weight-bold">N {{$Crypto->name_fa}}</span>
                                                    به حساب ما منتقل کرده و رسید انتقال وجه یا آدرس کیف پول خود را در این قسمت وارد
                                                    نمایید.</p>

                                                <div class="text-center">
                                                    <button  id="qrShow" type="button" class="btn text btn-primary btn-sm w-md" data-bs-toggle="modal" data-bs-target="#myModal2">اسکن qr  کد کیف پول</button>
                                                </div>

                                                <div class="col-md-12 p-0 form-group mb-3">
                                                    <label for="firstName1">لینک تراکنش (TxID)</label>
                                                    <input type="text" class="form-control text-center ltr-dir" name="transaction_link" id="transaction_link" required placeholder="TxID">
                                                    <div class="text-right mt-1 ml-1">
                                                        <a class="waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#myModal">TxID چیست؟</a>
                                                    </div>
                                                    <div class="invalid-feedback">لینک تراکنش را درج کنید</div>
                                                </div>
                                            @endif

                                            <div class="col-md-12 p-0 form-group mb-3">
                                                <label for="firstName1">کارمزد فروش</label>
                                                <span class="form-control text-center text-primary bg-light disabled" style="background-color: #EEE;" id="transfer_fee">
                                                    @{{ show_order_fee }}
                                                    <span v-if="isLoading">
                                                        <span class="spinner-grow text-primary" role="status" style="height: 17px;width: 17px"></span>
                                                    </span>
                                                    تومان
                                                </span>
                                            </div>

                                            <div class="card border border-success my-4">
                                                <div class="text-center py-3">مبلغ دریافتی: <span id="payment">@{{payment}}</span></div>
                                            </div>

                                            @include('user.layouts.SellMethod')

                                            <div class="text-center my-3">
                                                <button class="btn btn-danger btn-block">ثبت درخواست</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            @if($Crypto->symbol != 'USDT')
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title mb-4">نمودار</h4>
                        <div class="mt-4">
                            <div id="tradingview_f6243"></div>
                            <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/{{$Crypto->name}}" rel="noopener" target="_blank"></a></div>
                        </div>
                    </div>
                </div>
            @endif
            <div class="card">
                <div class="card-body">
                    <h5> نکات و هشدارها</h5>
                    <hr>
                    <div class="text-14 mb-md-5">
                        <p>برای فروش {{$Crypto->name_fa}} به ما، ابتدا میزان {{$Crypto->name_fa}} مورد نظر را جهت فروش در فیلد مقدار {{$Crypto->name_fa}} وارد نمایید، پس از آگاهی از مقدار معادل آن به تومان، دقیقا معادل مقداری که در فیلد
                            مقدار {{$Crypto->name_fa}} وارد کرده اید را به آدرس کیف پول {{ getSetting('app_name_farsi') }} که در همین صفحه ارائه شده است
                            انتقال دهید و سپس لینک یا شماره تراکنشی که به شما ارائه می شود را در بخش لینک تراکنش
                            وارد نموده و دکمه «ثبت درخواست» را کلیک نمایید.</p>
                        <p>پس از ثبت، درخواست شما توسط همکاران ما بررسی شده و در صورت تایید انتقال، پس از گذشت چند
                            ساعت معادل تومانی آن به حساب بانکی شما که در بخش اطلاعات کاربری مشخص کرده اید، واریز
                            خواهد شد. چنان چه هنوز اطلاعات حساب بانکی خود را در سیستم ثبت نکرده اید، به بخش&nbsp;<a
                                href="{{asset('')}}profile/financial" target="_blank">اطلاعات
                                مالی</a> مراجعه کرده و اطلاعات مورد نیاز را ارسال کنید.</p>
                        <p>چنان چه شماره شبای حساب بانکی ثبت شده باشد، انتقال وجه بدون کسر کارمزد بانکی انجام می
                            شود، در غیر این صورت کارمزد انتقال کارت به کارت از مبلغ کسر خواهد شد.</p>
                        <p>اگر به هر دلیلی مشکلی در ارائه لینک تراکنش داشته باشید می توانید، اسکرین شات تراکنش انجام
                            شده را در قسمت «فایل پیوست» انتخاب کنید تا به همراه درخواست برای ما ارسال شود.</p>
                        <p>برای کسب راهنمایی و مشاوره بیشتر نیز می توانید از بخش پشتیبانی تلگرام و یا پشتیبانی
                            آنلاین وب سایت با همکاران ما در ارتباط باشید، همچنین همه روزه به جز ایام تعطیل می توانید
                            از طریق شماره تماس های درج شده در سایت با ما در ارتباط باشید.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="myModal" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> TxID چیست؟</h5>
                </div>
                <div class="modal-body">
                    <p>لینک تراکنش یا همان TxID یک عبارت 64 کاراکتری بوده که ترکیبی از اعداد و حروف است و جهت
                        رهگیری
                        تراکنش استفاده می شود.</p>
                    <p>بعنوان مثال:
                        <small>3fc9153b7bdffcdfae092092320612c9c3c94351f600d80ad75f3915909b488b</small>
                    </p>
                    <p>ممکن است TxID را کمی با تأخیر دریافت نمایید، لذا پس از انجام تراکنش چند دقیقه صبر کرده و
                        پس
                        از دریافت درخواست را ثبت نمایید.</p>
                    <p>چنان چه TxID را به درستی وارد نکرده باشید امکان صحت سنجی خودکار وجود نخواهد داشت بنابراین
                        ممکن است تأیید درخواست شما بیش از حد معمول زمان نیاز داشته باشد.</p>
                    <p>دقت نمایید هنگامی که شما انتقال را انجام می دهید، مقداری نیز به عنوان کارمزد توسط سرویس
                        دهنده
                        کیف پول شما کسر می شود، اما شما می بایست مقداری که هنگام انتقال وارد کرده اید را در بخش
                        فروش
                        به ما وارد نمایید.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">متوجه شدم</button>
                </div>
            </div>
        </div>
    </div>

    <div id="myModal2" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">اسکن qr  کد کیف پول</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mx-auto">
                    <div class="text-center" id="qr{{$result['address_id'] . $network}}" style="display: none;" class="qr-box">
                        @if(isset($result['qr_image']))
                       @php
                       echo $result['qr_image'];
                       @endphp
                       @endif
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@stop

@section('js')
@stop

@section('script')
    <script src="{{ asset('js/vue.min.js') }}"></script>
    <script src="{{ asset('js/digitbox.min.js') }}"></script>
    @if($Crypto->symbol != 'USDT')
        <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
        <script type="text/javascript">
            new TradingView.widget(
                {
                    "width": '100%',
                    "height": '450',
                    "symbol": "BINANCE:{{$Crypto->symbol}}USDT",
                    "interval": "15",
                    "timezone": "Etc/UTC",
                    "theme": "light",
                    "style": "1",
                    "locale": "en",
                    "toolbar_bg": "#f1f3f6",
                    "enable_publishing": false,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "container_id": "tradingview_f6243"
                }
            );
        </script>
    @endif

    <script>
    var url = $('meta[name=url]').attr("content");
    var csrf = $('meta[name=_token]').attr("content");

    const vm1 = new Vue({
        el: '#coinCalculator',
        data: {
            coinName: '{{$Crypto->name}}',
            coin: null,
            rial: null,
            fee: null,
            type: 'sell',
            stock: null,
            stock_ir: null,
            isLoading: true,
            payment:0,
            getParam: null,
            serverCoinsPrice: {},
            transfer_fee: null,
            transfer_fee_amount: null,
            has_destination_tag:0,
            sell_order_fee: null,
            show_order_fee: 0,
            sell_method:0
        },
        methods: {
            LoadedFee: function (coin) {
                fetch(url +"infoCurrency/"+ this.coinName +'?type='+this.type,
                    {
                        method: 'POST',
                        mode: 'cors',
                        cache: 'no-cache',
                        headers: {
                            'Content-Type': 'application/json',
                            'Connection': 'keep-alive',
                        },
                        body: JSON.stringify({_token: csrf ,model:'buy'})
                    }
                ).then(res => {
                    return res.json()
                })
                    .then(data => {
                        this.serverCoinsPrice = data;
                        this.fee = data.fee.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                        this.stock = data.balances;
                        this.sell_order_fee = data.sell_order_fee;
                        this.stock_ir = Math.round((data.fee * data.balances)).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                        this.transfer_fee =data.transfer_fee_amount;
                        this.transfer_fee_amount = Math.round(data.transfer_fee_amount * data.fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                        this.isLoading = false;
                        if(this.getParam){
                            this.rial = this.getParam;
                            this.calculateResult('rial',false)
                            this.getParam = null
                        }
                    });

            },
            calculateResult(model, update = true) {
                if(update)
                    this.updatePrice();

                fee = parseInt(this.fee.replace(/\,/g, ''));
                transfer_fee = 0;

                if(model == 'coin'){
                    const coin = Math.round(this.coin * fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                    if(coin.toString() !== 'NaN') {
                        this.payment = coin;
                        this.rial = this.payment;
                        var show_order_fee = parseInt(((this.coin * fee) * (this.sell_order_fee / 100)).toFixed(0));
                        // console.log(this.coin * fee, this.sell_order_fee, show_order_fee)
                        this.show_order_fee = new Intl.NumberFormat('en-US').format(show_order_fee);
                        this.payment = Math.round(parseInt(this.payment.replace(/\,/g, '')) - (transfer_fee + show_order_fee)).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                    }
                }else{
                    amount = parseInt(this.rial.replace(/\,/g, ''))
                    this.rial = amount.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                    this.coin =   +((amount / fee).toFixed({{$Crypto->percent}}));// Math.round((amount / fee))/10;
                    if(this.rial == 'NaN' || this.rial =='')
                        this.payment = 0;
                    else
                        this.payment =  Math.round(amount+transfer_fee).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
                }

            },
            updatePrice: (delay(function() {
                this.LoadedFee();
            },1500)),
        },
        watch: {
            serverCoinsPrice: function (newValue,oldValue) {
                if(oldValue.fee && (newValue.fee != oldValue.fee)){
                    this.calculateResult('coin',false)
                }
            }
        },
        mounted() {
            this.LoadedFee();
            setInterval(() => {
                this.LoadedFee();
            }, 20000);

            $('#coin').digitbox({float: true});
        },
        created()
        {
            let uri = window.location.search.substring(1);
            let params = new URLSearchParams(uri);
            if(params.get("amount"))
                this.getParam = params.get("amount")

        },
    })

    $(document).ready(function () {
        if(!$('#tagValue').val()) {
            $('.tag-section').hide();
        }
        $('#coin_sell').ajaxForm({
            beforeSend: function () {
                loading();
            },
            complete: function (data) {
                data = data.responseJSON;
                if (data.status == true) {
                    location.href="{{asset('').$Crypto->name}}/sell/"+data.id;
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "توجه",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })

                }
                unloading();
            }
        });
    });

    $("#qrShow").click(function () {
        $('.mx-auto .text-center').hide();
        const addressValue = $('#addressValue').val();
        const network = $('#networkName').val();

        const qr = '#qr' + addressValue + network;
        $(qr).show();
    });

    $(".nav-link-x").click(function () {
       if(!$('#tagValue').val()) {
            $('.tag-section').hide();
        }
        else {
             $('.tag-section').show();
        }
    });



    function copyToClipboard() {
        var copyText = document.getElementById("addressValue").value;
        navigator.clipboard.writeText(copyText).then(() => {
        });
        }



</script>

@stop
