<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <!-- SEO Meta Tags -->
    <title>CryptoExchange - The Future of Crypto Trading</title>
    <meta name="description" content="Experience the next generation of cryptocurrency exchange. Fast, secure, and reliable trading platform for Bitcoin, Ethereum, and more.">
    <meta name="keywords" content="cryptocurrency, crypto exchange, bitcoin, ethereum, trading, blockchain">
    <meta name="author" content="CryptoExchange">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="CryptoExchange - The Future of Crypto Trading">
    <meta property="og:description" content="Experience the next generation of cryptocurrency exchange. Fast, secure, and reliable trading platform.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url('/') }}">
    
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Custom Landing CSS -->
    <link href="{{ asset('css/landing.css') }}" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="container">
            <a href="{{ url('/') }}" class="navbar-brand">
                <span class="brand-icon">₿</span>
                <span class="brand-text">CryptoExchange</span>
            </a>
            
            <button class="navbar-toggler" id="navbarToggler" aria-label="Toggle navigation">
                <span></span>
                <span></span>
                <span></span>
            </button>
            
            <div class="navbar-menu" id="navbarMenu">
                <a href="#market" class="nav-link">Market</a>
                <a href="#about" class="nav-link">About Us</a>
                <a href="{{ route('login') }}" class="btn btn-outline" id="loginBtn">Login</a>
                <a href="{{ route('Register') }}" class="btn btn-primary" id="registerBtn">Register</a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="hero">
        <div class="hero-background"></div>
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">
                        The Future of<br>
                        <span class="gradient-text">Crypto Trading</span>
                    </h1>
                    <p class="hero-description">
                        Experience the next generation of cryptocurrency exchange. Fast, secure, and reliable trading platform for everyone.
                    </p>
                    <div class="hero-buttons">
                        <a href="{{ route('Register') }}" class="btn btn-primary btn-lg">Start Trading</a>
                        <a href="#market" class="btn btn-outline btn-lg">View Prices</a>
                    </div>
                </div>
                <div class="hero-image">
                    <div class="floating-card">
                        <div class="crypto-icon">₿</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Live Market Section -->
    <section class="market-section" id="market">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">Live Market Trends</h2>
                <p class="section-description">Real-time cryptocurrency prices and market data</p>
            </div>
            
            <div class="market-card">
                <div class="table-container">
                    <table class="crypto-table" id="cryptoTable">
                        <thead>
                            <tr>
                                <th>Asset</th>
                                <th>Price (USDT)</th>
                                <th>Price (IRT)</th>
                                <th>Change (24h)</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="cryptoTableBody">
                            <tr>
                                <td colspan="5" class="loading-cell">
                                    <div class="spinner"></div>
                                    <span>Loading market data...</span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="about-section" id="about">
        <div class="container">
            <div class="about-content">
                <div class="about-features">
                    <div class="feature-card">
                        <div class="feature-icon">🛡️</div>
                        <h3 class="feature-title">Secure Storage</h3>
                        <p class="feature-description">Industry-leading security protocols to keep your assets safe.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">⚡</div>
                        <h3 class="feature-title">Fast Execution</h3>
                        <p class="feature-description">Lightning-fast transaction processing for optimal trading.</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">🎧</div>
                        <h3 class="feature-title">24/7 Support</h3>
                        <p class="feature-description">Dedicated support team available around the clock.</p>
                    </div>
                </div>
                
                <div class="about-text">
                    <h2 class="about-title">About Our Platform</h2>
                    <p class="about-description">
                        We are a leading cryptocurrency exchange platform dedicated to providing a seamless and secure trading experience. 
                        Our mission is to make crypto accessible to everyone, from beginners to experienced traders.
                    </p>
                    <p class="about-description">
                        With state-of-the-art technology and a user-first approach, we ensure that your trading journey is smooth, 
                        transparent, and profitable. Join thousands of users who trust us with their digital assets.
                    </p>
                    <a href="{{ route('Register') }}" class="btn btn-primary btn-lg">Join Now</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p class="footer-text">© {{ date('Y') }} CryptoExchange. All rights reserved.</p>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
        // Pass Laravel variables to JavaScript
        window.apiUrl = "{{ url('/api/crypto-prices') }}";
        window.loginUrl = "{{ route('login') }}";
        window.registerUrl = "{{ route('Register') }}";
    </script>
    <script src="{{ asset('js/landing.js') }}"></script>
</body>
</html>
