@extends('admin.layouts.master')
@section('title', 'فروشگاه')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">فروشگاه محصولات</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="row">
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل فروش</p>
                                    <h5 class="mb-0">{{ $ordersCount }}</h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-success font-size-20">
                                        <i class="bx bxs-shopping-bag"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">درآمد کل</p>
                                    <h5 class="mb-0">{{ $income != 0 ? number_format($income) : '0' }}<small class="ms-2">تومان</small></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-warning font-size-20">
                                        <i class="bx bx-money"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">سفارش‌های در حال بررسی</p>
                                    <h5 class="mb-0">{{ $pendingOrders }}</h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-credit-card"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">کاربران فعال فروشگاه</p>
                                    <h5 class="mb-0">{{ $activeUsers }}</h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-dark font-size-20">
                                        <i class="bx bxs-user"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title">محصولات</div>
                    <div>
                        <a href="products" class="btn btn-light"><i class="mdi mdi-cart-arrow-right me-1"></i>مدیریت محصولات</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap">
                        <thead class="table-light">
                            <tr>
                                <th>عکس محصول</th>
                                <th>نام محصول</th>
                                <th>دسته بندی</th>
                                <th>قیمت</th>
                                <th>تعداد فروش</th>
                                <th>درآمد فروش</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($products) > 0)
                                @foreach($products as $product)
                                    <tr>
                                        <td><img src="{{ asset($product->image) }}" alt="product-img" title="product-img" class="avatar-md" /></td>
                                        <td><h5 class="font-size-14 text-truncate">{{ $product->title }}</h5></td>
                                        <td>{{ $product->category['title'] }}</td>
                                        <td>{{ number_format($product->product_price) }}<small class="ms-1">تومان</small></td>
                                        <td>{{ $product->sum_quantity != null ? $product->sum_quantity : '-' }}</td>
                                        <td>
                                            @if(isset($product->sum_final_price))
                                                {{ number_format($product->sum_final_price - $product->sum_delivery_price) }}
                                                <small class="ms-1">تومان</small>
                                            @else
                                                -
                                            @endIf
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="text-center mt-3"><a class="text-dark" href="products">مشاهده همه محصولات</a></div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="card-title mb-3">سفارشات</div>
                <div class="table-responsive">
                    <table class="table align-middle table-nowrap table-check">
                        <thead class="table-light">
                        <tr>
                            <th class="align-middle">شناسه</th>
                            <th class="align-middle">نام خریدار</th>
                            <th class="align-middle">تاریخ</th>
                            <th class="align-middle">مبلغ پرداختی</th>
                            <th class="align-middle">وضعیت سفارش</th>
                            <th class="align-middle">روش پرداخت</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if( isset($orders))
                            @foreach( $orders as $order )
                                <tr>
                                    <td><a href="#" class="text-body fw-bold">{{ $order->id }}</a></td>
                                    <td><a href="{{ asset('').env('PanelPrefix') }}/users/{{ $order->user->id }}">{{ $order->user->name . ' ' . $order->user->family }}</a></td>
                                    <td>{{ $order->date }}</td>
                                    <td>{{ number_format($order->final_price) }}<small class="ms-1">تومان</small></td>
                                    <td>
                                        @if( $order->status == 'payment-confirm' )
                                            <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                        @elseif( $order->status == 'payment-pending' )
                                            <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                        @elseif( $order->status == 'payment-cancel' )
                                            <span class="badge badge-pill badge-soft-danger font-size-12">پرداخت ناموفق</span>
                                        @elseif( $order->status == 'done' )
                                            <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                        @elseif( $order->status == 'cart' )
                                            <span class="badge badge-pill badge-soft-warning font-size-12">سبد خرید</span>
                                        @elseif( $order->status == 'canceled' )
                                            <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if( $order->payment_method == 'wallet' )
                                            <span>کیف پول</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                    </table>
                </div>
                <div class="text-center"><a class="text-dark" href="{{ asset('').env('PanelPrefix') }}/shop-orders/">مشاهده همه سفارشات</a></div>
            </div>
        </div>
    </div>
@stop

@section('script')


@stop
