@extends('admin.layouts.master')
@section('title', 'محصولات')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">محصولات فروشگاه</h4>
            </div>
        </div>
    </div>
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
    @endif
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title">محصولات</div>
                    <div>
                        <a href="product-index" class="btn btn-light"><i class="mdi mdi-cart-arrow-right me-1"></i>اضافه کردن محصول جدید</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap">
                        <thead class="table-light">
                        <tr>
                            <th>عکس محصول</th>
                            <th>نام محصول</th>
                            <th>دسته بندی</th>
                            <th>قیمت</th>
                            <th>تعداد فروش</th>
                            <th>درآمد فروش</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                                <tr>
                                    <td><img src="{{ asset($product->image) }}" alt="product-img" title="product-img" class="avatar-md" /></td>
                                    <td><h5 class="font-size-14 text-truncate">{{ $product->title }}</h5></td>
                                    <td>{{ $product->category != null ? $product->category['title'] : '-' }}</td>
                                    <td>{{ number_format($product->product_price) }}<small class="ms-1">تومان</small></td>
                                    <td>{{ $product->sum_quantity != null ? $product->sum_quantity : '-' }}</td>
                                    <td>
                                        @if(isset($product->sum_final_price))
                                            {{ number_format($product->sum_final_price - $product->sum_delivery_price) }}
                                            <small class="ms-1">تومان</small>
                                        @else
                                            -
                                        @endIf
                                    </td>
                                    <td>
                                        <div class="d-flex gap-3">
                                            <a href="product-index?id={{ $product->id . '-' . $product->title }}" class="text-success"><i class="mdi mdi-pencil font-size-18"></i></a>
                                            <a class="text-danger pointer-event" onclick="remove({{ $product->id }})"><i class="mdi mdi-delete font-size-18"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script>
        function remove(id){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor: "#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{ asset('').env('PanelPrefix') }}/product/" + id + "/delete",
                        type: 'DELETE',
                        data: {_token: "{{ csrf_token() }}", id:id},
                    });
                }
            }).then((data) => {
                if(data != undefined) {
                    if(data.value.status==true){
                        swal.fire({
                            title:'انجام شد!',
                            icon: 'success',
                            text: data.value.messege,
                        }).then(function () {
                            location.reload()
                        });
                    }
                    else{
                        swal("خطا",  data.value.messege  , "error");
                    }
                }
            });
        }
    </script>
@stop
