@extends('admin.layouts.master')
@section('title', 'دسته بندی فروشگاه')

@section('content')
    <div id="category">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">دسته‌بندی‌های فروشگاه</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="card col-12">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-4">
                        <div class="card-title mb-0">دسته‌بندی‌ها</div>
                        <div>
                            <button type="button" v-on:click="clear()" class="btn btn-light mb-3" data-bs-toggle="modal" data-bs-target=".bs-admin-modal-lg"><i class="mdi mdi-list-status  me-1"></i>اضافه کردن دسته جدید</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-nowrap" id="myTable">
                            <thead class="table-light">
                            <tr>
                                <th>شناسه</th>
                                <th>عنوان دسته</th>
                                <th>توضیحات</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach( $categories as $category )
                                    <tr>
                                        <td>{{ $category->id }}</td>
                                        <td>{{ $category->title }}</td>
                                        <td>{{ $category->description }}</td>
                                        <td>
                                            @if( $category->active == 1 )
                                                <span>فعال</span>
                                            @else
                                                <span>غیرفعال</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" v-on:click="editCategory({{ $category->id }}), getDetails({{ $category->id }})" data-bs-toggle="modal" data-bs-target=".bs-admin-modal-lg" class="btn action-icon text-success"> <i class="mdi mdi-book-edit font-size-18"></i></button>
                                            <button type="button" onclick="remove({{ $category->id }})" class="btn action-icon text-danger"> <i class="mdi mdi-trash-can font-size-18"></i></button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        {{--Submit Category--}}
        <div class="modal fade bs-admin-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 v-if="id" class="modal-title" id="myLargeModalLabel">ویرایش دسته‌بندی</h5>
                        <h5 v-else class="modal-title" id="myLargeModalLabel">اضافه کردن دسته‌بندی جدید</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form autocomplete="off" method="post" action="" novalidate  enctype="multipart/form-data">
                            @csrf
                            <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                                <input type="text" name="id" :value="id" id="active" hidden>
                                <div class="pe-md-1 form-group mb-3">
                                    <label for="Name">عنوان دسته</label>
                                    <input type="text" class="form-control" :value="title" name="title" id="title" required>
                                </div>
                                <div class="pe-md-1 form-group mb-3">
                                    <label for="Name">توضیحات</label>
                                    <input type="text" class="form-control" :value="description" name="description" id="description">
                                </div>
                                <div class="pe-md-1 form-group mb-3">
                                    <label for="Name">وضعیت: </label>
                                    <input type="radio" value="1" name="active" id="active1" :checked="active == 1 ? true : false">
                                    <label for="active1">فعال</label>
                                    <input type="radio" value="0" name="active" id="active0" :checked="active == 0 ? true : false">
                                    <label for="active0">غیرفعال</label>
                                </div>
                                <div class="col-md-4 m-auto">
                                    <button type="submit" class="btn btn-primary btn-block">ثبت درخواست</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')

    <script src="{{ asset('js/vue.min.js') }}"></script>
    <script>
        const vue = new Vue({
            el: '#category',
            data: {
                category: {},
                id: '',
                title: '',
                description: '',
                active: '',
            },
            methods: {
                getDetails: function (categoryId) {
                    fetch("{{ asset('').env('PanelPrefix') }}/categories/" + categoryId, {
                        method: 'GET'
                    })
                        .then(res => {
                            return res.json();
                        })
                        .then(data => {
                            this.category = data.data;
                            this.title = this.category.title;
                            this.description = this.category.description;
                            this.active = this.category.active;
                        })
                },
                editCategory(id) {
                    this.id = id;
                },
                clear() {
                    this.id = null;
                    this.title = '';
                    this.description = '';
                    this.active = 1;
                }
            }
        })
    </script>

    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                complete: function (data) {
                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href = "{{ asset('').env('PanelPrefix') }}/categories";
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            });
        });

        function remove(id){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{ asset('').env('PanelPrefix')}}/categories ",
                        type: 'DELETE',
                        data: {_token: "{{ csrf_token() }}",id:id},
                    });
                }
            }).then((data) => {
                if(data.value.status == true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload()
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }
    </script>
@stop
