@extends('admin.layouts.master')
@section('title', 'فروشگاه')
@section('css')
    <style>
        .image-input {
            position:relative;
            display:inline-block;
            border-radius:.42rem;
            background-repeat:no-repeat;
            background-size:cover
        }
        .image-input.image-input-outline .image-input-wrapper {
            box-shadow:0 .5rem 1.5rem .5rem rgba(0,0,0,.075)
        }
        .image-input .image-input-wrapper {
            border-radius:2.42rem;
            background-repeat:no-repeat;
            background-size:cover
        }
        .image-input .image-input-wrapper img {
            border-radius:2.42rem
        }
        .btn.btn-white.btn-shadow {
            box-shadow:0 9px 16px 0 rgba(24,28,50,.25)!important
        }
        .btn.btn-icon.btn-circle {
            border-radius:50%
        }
        .btn.btn-icon.btn-xs {
            height:24px;
            width:24px;
            display:flex;
            justify-content:center;
            align-items:center;
            background:#fff
        }
        .btn:not(:disabled):not(.disabled) {
            cursor:pointer
        }
        .image-input [data-action=change] {
            cursor:pointer;
            position:absolute;
            left:-10px;
            top:-4px
        }
        .image-input [data-action=cancel],
        .image-input [data-action=remove] {
            position:absolute;
            left:-10px;
            bottom:4px
        }
        .image-input [data-action=change] input {
            width:0!important;
            height:0!important;
            overflow:hidden
        }
    </style>
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">اضافه کردن محصول</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div>جهت درج محصول در سایت، اطلاعات زیر را به دقت پر کنید.</div>
                    <div>
                        <a href="categories" class="btn btn-light"><i class="mdi mdi-view-list me-1"></i>مدیریت دسته بندی‌ها</a>
                    </div>
                </div>

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="add-product" enctype="multipart/form-data">
                    @csrf
                    {{--For Edit Product--}}
                    <input type="text" name="product_id" value="{{ isset($product) ? $product->id : '' }}" hidden>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">نام محصول</label>
                        <input type="text" class="form-control" name="title" value="{{ isset($product) ?  $product->title : old('title') }}">
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">دسته بندی</label>
                            <select class="form-control" name="category_id">
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ isset($product) && $category->id == $product->category_id ? 'selected' : ''  }}>{{ $category->title }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">قیمت خرید</label>
                            <input type="text" class="form-control" name="buy_price" value="{{ isset($product) ?  $product->buy_price : old('buy_price') }}">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">تعداد</label>
                            <input type="text" class="form-control" name="quantity" value="{{ isset($product) ?  $product->quantity : old('quantity') }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">قیمت محصول</label>
                            <input type="text" class="form-control" name="price" value="{{ isset($product) ?  $product->product_price : old('price') }}">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">توضیحات محصول</label>
                        <textarea rows="4" class="form-control" name="description">{{ isset($product) ?  $product->description : old('description') }}</textarea>
                    </div>
                    <hr class="my-5">
                    <div class="row mb-4">
                        <label for="horizontal-password-input" class="col-sm-3 col-form-label mb-3">تصویر محصول</label>
                        <div class="col-sm-9">
                            <div class="image-input image-input-outline image-input-changed">
                                <div class="image-input-wrapper bg-light">
                                    <img id="picture" src="{{ asset(isset($product ) && $product->image != null ? $product->image : 'images/product/defult.png') }}" width="320px" />
                                </div>
                                <label class="btn btn-xs btn-icon btn-circle btn-white btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="تغییر آواتار">
                                    <i class="fa fa-pen icon-sm text-muted"></i>
                                    <input type="file" name="image">
                                </label>
                            </div>
                        </div>
                    </div>
                    <hr class="my-5">
                    <div class="mb-3">
                        <div class="col-md-6">
                            <label id="free_delivery" class="form-label">هزینه ارسال محصول رایگان خواهد بود</label>
                            <input for="free_delivery" type="checkbox" value="1" name="free_delivery" {{ isset($product->free_delivery) && $product->free_delivery != null ? 'checked' : '' }} autocomplete="off">
{{--                            <input type="text" class="form-control" name="delivery_price" {{ isset($product) ?  $product->delivery_price : old('delivery_price') }}>--}}
{{--                            <div class="alert alert-secondary mt-3" role="alert">--}}
{{--                                در صورتیکه مقدار را 0 وارد کنید هزینه ارسال رایگان خواهد بود(مناسب برای محصولاتی که فیزیکی نیستند).--}}
{{--                            </div>--}}
                        </div>
                    </div>
                    <div class="my-4 text-center">
                        <button type="submit" class="btn btn-primary">{{ isset($product) ? 'ویرایش محصول' : 'اضافه کردن محصول' }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@stop

@section('script')


    <script>
        $(document).ready(function () {
            $('.image-input input').change(function() {
                var prev = $(this).parent().parent().find('img#picture');
                var reader = new FileReader();
                reader.onload = function (e) {
                    prev.attr('src', e.target.result);
                }
                reader.readAsDataURL(this.files[0]);
            });
        });
    </script>
@stop
