@extends('admin.orders.single')

        @section('orders_model')
        <img src="{{asset('')}}app-assets/images/currency/webmoney.svg" style="position: absolute;width: 13%;left: 20px;top: 20px;">
        <hr width="60%">
        <p>فهرست محصولات / خدمات درخواستی</p>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="">

                <tr>
                    <th class="text-center">#</th>
                    <th class="text-center w-60">شرح</th>
                    <th class="text-center">مقدار / تعداد</th>
                    <th class="text-center">قیمت واحد</th>
                    <th class="text-center">مبلغ کل</th>
                </tr>
                </thead>
                <tbody class="text-center">
                    <tr>
                        <td scope="row" class="sans-serif">1</td>
                        <td>{{$result->order->detail->type .' '. $result->order->detail->title}}</td>
                        <td>{{$result->order->detail->amount_dollar}}{{$result->order->detail->dollar}} </td>
                        <td>{{number_format($result->orders_model->price_dollar)}}</td>
                        <td>{{number_format($result->orders_model->amount_rial)}}</td>
                    </tr>
                    <tr class="border-0">
                        <th class="border-0"></th>
                    </tr>
                    @if($result->orders_model->type =='buy')
                    <tr>
                        <td class="border-0"></td>
                        <th class="w-60">آدرس کیف پول گیرنده</th>
                        <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                            <i class="ft-copy"></i>  <span>{{$result->orders_model->wallet_address}}</span>
                        </td>
                    </tr>
                        @if(isset($result->orders_model->transaction_comment))
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">توضیحات</th>
                                <td colspan="4">
                                    <span>{{$result->orders_model->transaction_comment}}</span>
                                </td>
                            </tr>
                        @endif
                        @if(isset($result->orders_model->transaction_security_code))
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">کد امنیتی</th>
                                <td colspan="4" class="sans-serif">
                                   <span>{{$result->orders_model->transaction_security_code}}</span>
                                </td>
                            </tr>
                        @endif
                    @elseif($result->orders_model->type =='buy-product')
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">لینک محصول</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="ft-copy"></i>  <span>{{$result->orders_model->url_product}}</span>
                            </td>
                        </tr>
                        @if(isset($result->orders_model->username) && isset($result->orders_model->password) )
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">نام کاربری</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->username}}</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">رمز عبور</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->password}}</span>
                                </td>
                            </tr>
                        @endif
                    @else
                        @if(!isset($result->orders_model->paymer_number))
                        <tr>
                            <td class="border-0"></td>
                            <th class="w-60">اکانت پرداخت کننده</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="ft-copy"></i>  <span>{{$result->orders_model->wallet_address}}</span>
                            </td>
                        </tr>
                        @else
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">شماره Paymer</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->paymer_number}}</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="border-0"></td>
                                <th class="w-60">کد Paymer</th>
                                <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                    <i class="ft-copy"></i>  <span>{{$result->orders_model->paymer_code}}</span>
                                </td>
                            </tr>
                        @endif
                    @endif

                    @if(isset($result->order->payment_tracking))
                        <tr>
                            <td class="border-0"></td>
                            <th scope="row">کد پیگیری درگاه پرداخت</th>
                            <td colspan="4" class="sans-serif">
                                <span>{{$result->order->payment_tracking}}</span>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
        @stop
