@extends('admin.layouts.master')
@section('title', 'جزئیات سفارش '.$result->order->detail->type .' '. $result->order->detail->title)
@section('css')
@stop

@section('content')

    @if(!isset($result->order->payment) && $result->order->status=='معلق' && date("Y-m-d H:i:s") > date("Y-m-d H:i:s",strtotime('+15 minutes',strtotime($result->order->created_at))))
        <div class="col-md-12 p-0">
            <div class="alert alert-card alert-dark text-center" role="alert">
                اگر این سفارش رو بررسی کردید میتوانید حذف نمایید. <button onclick="remove()" class="btn btn btn-danger ml-3">حذف</button>
                <button type="button" class="btn btn-light close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">بستن</span>
                </button>
            </div>
        </div>
    @endif

    @if($result->order->status == 'معلق,پرداخت شده')
        <div class="col-md-12 p-0">
            <div class="alert alert-card alert-dark text-center" role="alert">
                اگر این سفارش را از طریق تیکت بررسی کردید میتوانید وضعیت را به عودت تغییر دهید. <button onclick="return_amount(1)" class="btn btn btn-success ml-3">عودت مبلغ</button>
                <button type="button" class="btn btn-light close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">بستن</span>
                </button>
            </div>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-12">
            <div class="card border ">
                <div class="card-body">
                    <div class="invoice-title">
                        <h4 class="float-end font-size-16">شماره سفارش # {{$result->order->id}}</h4>
                        <div class="mb-4">
                            <img src="{{ asset('images/logo/logo-dark.svg') }}" alt="logo" height="20"/>
                        </div>
                        <hr>
                        <div class="row">
                            <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                            <div class="col-sm-12">
                                <div class="my-2">
                                    <strong>تاریخ ثبت:</strong>
                                    {{$result->order->date}}
                                </div>
                                <div class="my-2">
                                    <strong>مبلغ سفارش:</strong>
                                    {{number_format($result->order->amount)}} تومان
                                </div>
                                <div class="my-2">
                                    <strong>وضعیت:</strong>
                                    @if($result->order->status == 'پرداخت شده' || $result->order->status == 'انجام شده'|| $result->order->status == 'منتقل شده')
                                        <span class="badge bg-success font-weight-light">{{$result->order->status}}</span>
                                    @elseif($result->order->status == 'رد شده')
                                        <span class="badge bg-danger font-weight-light">{{$result->order->status}}</span>
                                    @elseif($result->order->status == 'در دست اقدام')
                                        <span class="badge bg-success font-weight-light">پرداخت شده</span>
                                        <span class="badge bg-info font-weight-light">{{$result->order->status}}</span>
                                    @elseif($result->order->status == 'در حال انتقال ارز')
                                        <span class="badge bg-success font-weight-light">پرداخت شده</span>
                                        <span class="badge bg-warning font-weight-light">{{$result->order->status}}</span>
                                    @elseif($result->order->status == 'معلق')
                                        <span class="badge bg-dark font-weight-light">معلق</span>
                                    @else
                                        <span class="badge bg-warning font-weight-light">{{$result->order->status}}</span>
                                    @endif
                                </div>
                                @if($result->order->type == 'sell')
                                    <div class="my-2">
                                        <strong>پرداخت از طریق:</strong>
                                        @if(isset($result->order->id_cardbank))
                                            شماره کارت  <span dir="ltr">{{substr_replace($result->order->cardbank->card_number, str_repeat("*", 6), 6, 6)}}</span>
                                        @else
                                            کیف پول شما در {{ getSetting('app_name_farsi') }}
                                        @endif
                                    </div>
                                @else
                                    <div class="my-2">
                                        <strong>پرداخت از طریق:</strong>
                                        {{$result->order->payment_gateway}}
                                    </div>
                                @endif
                                @if(isset($result->order->description))
                                    <div class="my-2">
                                        <strong>توضیحات سفارش:</strong>
                                        {{$result->order->description}}
                                    </div>
                                @endif
                                <div class="my-2">
                                    <strong>سفارش از طریق:</strong>
                                    {{$result->order->via}}
                                </div>
                                <div class="my-2">
                                    <strong>سفارش از آی پی:</strong>
                                    {{$result->order->ip ?? '----'}}
                                </div>
                                @if(isset($result->ticket))
                                    @if($result->ticket->seen_admin == 1)
                                        <div class="alert alert-secondary alert-dismissible fade show" role="alert">
                                            <i class="mdi mdi-chat me-2"></i>
                                            <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است و جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="amber"><i class="ft-link"></i> لینک تیکت </a>
                                        </div>
                                    @else
                                        <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                            <i class="mdi mdi-chat me-2"></i>
                                            <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است که هنوز ندیده اید و لطفا جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="typo_link text-primary"><i class="ft-link"></i> لینک تیکت </a>
                                        </div>
                                    @endif
                                @endif
                                <div class="my-4">
                                    <span class="mb-3">مشخصات خریدار:</span>
                                    <div class="table-responsive">
                                        <table class="table align-middle table-nowrap table-hover">
                                            <thead class="table-light">
                                            <tr>
                                                <th scope="col" style="width: 70px;">#</th>
                                                <th scope="col">نام و نام خانوادگی</th>
                                                <th scope="col">شماره تماس</th>
                                                <th scope="col">ایمیل</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <div class="avatar-xs">
                                                        <img src="{{ asset('images/users/user.png') }}" width="30px">
                                                    </div>
                                                </td>
                                                <td>
                                                    <h5 class="font-size-14 mb-1">{{$result->user->name .' '.$result->user->family}}</h5>
                                                </td>
                                                <td>{{$result->user->mobile}}</td>
                                                <td>{{$result->user->email??'ثبت نشده است'}}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            @if($result->order->status =='معلق,پرداخت شده')
                                <h5 class="text-center m-auto col-md-8 text-dark">
                                    سفارش کاربر بعلت پرداخت با کارت غیر از کارت های تایید شده در وضعیت معلق و پرداخت شده میباشد و تیکتی به صورت اتوماتیک برای کاربر جهت این سفارش ایجاد شده است و از طریق تیکت پیگیری کنید!
                                </h5>
                            @elseif($result->order->status =='معلق,عودت')
                                <h5 class="text-center m-auto col-md-8 text-dark">
                                    سفارش کاربر بعلت پرداخت با کارت غیر از کارت های تایید شده در وضعیت معلق و پرداخت شده بود که تیکتی به صورت اتوماتیک برای کاربر جهت این سفارش ایجاد شده و اکنون <b>مبلغ این سفارش به کاربر عودت داده شده است!</b>
                                </h5>
                            @elseif(isset($result->order->payment))
                                <hr width="60%">
                                @if(isset($result->BackStock))
                                    <h5 class="text-center m-auto col-md-8 text-danger">
                                        این سفارش پرداخت شده است اما ثبت سفارش با موفقیت انجام نشده و همچنین مبلغ این سفارش به کیف پول کاربر انتقال یافته است.
                                    </h5>
                                @else
                                    <h5 class="text-center m-auto col-md-8 text-danger">
                                        این سفارش پرداخت شده است اما ثبت سفارش با موفقیت انجام نشده و <b>متاسفانه مبلغ به کیف پول کاربر عودت نشده است</b> و بر روی دکمه عودت کلیک کنید.
                                    </h5>
                                    <div class="text-center mt-2">
                                        <button onclick="return_amount(0)" class="btn btn btn-success ml-3">عودت مبلغ</button>
                                    </div>
                                @endif
                                <h4 class="text-center mt-3">موجودی فعلی کیف پول کاربر: {{number_format($result->user->wallet)}} تومان </h4>

                            @else
                                <hr width="60%">
                                <h5 class="text-center m-auto col-md-8 text-info">
                                    سفارش پرداخت نشده است و در حالت معلق میباشد و این سفارش از دید کاربر مخفی است و فقط شما میبینید و اگر بیش از 15 دقیقه از ثبت این سفارش گذشته باشد میتوانید آن را حذف کنید.
                                </h5>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')
@stop

@section('script')
    <script>

        function remove(){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/orders/{{$result->order->id}}/remove",
                        type: 'DELETE',
                        data: {_token: "{{ csrf_token() }}"},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.href = "{{asset('').env('PanelPrefix')}}/orders";
                    });
                }
                else{
                    swal.fire("خطا",  data.value.messege  , "error");
                }
            });
        }


        function return_amount(status){
            swal.fire({
                title: "از عودت اطمینان دارید؟",
                text: "اگر کیف پول را انتخاب کنید مبلغ اتوماتیک به کیف پول کاربر اضافه میشود",
                icon: "info",
                input: 'checkbox',
                inputPlaceholder: 'آیا به کیف پول واریز شود؟',
                showCancelButton: true,
                inputValue: "checked",
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#00d213",
                cancelButtonText: "نه",
                preConfirm: (input) => {
                    return $.post("{{asset('').env('PanelPrefix')}}/orders/{{$result->order->id}}/return-amount",
                        {
                            wallet:input,
                            status:status,
                            _token: "{{ csrf_token() }}"
                        });

                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal.fire("خطا",  data.value.messege  , "error");
                }
            });
        }
    </script>
@stop
