<div class="row">
    <div class="col-md-12 text-left">
        <p class="">
            <strong>شماره تراکنش:</strong>
            <span class="text-info">{{$result->finance->id}}#</span>
        </p>
        <p class="mb-0">
            <strong>مبلغ تراکنش:</strong>
            <strong class="text-primary">{{number_format($result->finance->amount)}}</strong>
        </p>

        <p class="mb-0">
            <strong>وضعیت:</strong>
            @if($result->finance->status =='در دست اقدام')
                <span class="badge badge-pill bg-warning m-1 font-weight-light">در دست اقدام</span>
            @elseif($result->finance->status =='رد شده')
                <span class="badge badge-pill bg-danger m-1 font-weight-light">رد شده</span>
            @elseif($result->finance->status =='معلق,پرداخت شده' || $result->finance->status =='معلق,عودت')
                <span class="badge badge-pill bg-dark px-4 m-1 font-weight-light">معلق</span>
                <span class="badge badge-pill bg-success m-1 font-weight-light">{{substr($result->finance->status, strpos($result->finance->status, ",") + 1)}}</span>
            @elseif($result->finance->status =='ناموفق')
                <span class="badge badge-pill bg-danger m-1 font-weight-light">ناموفق</span>
            @elseif($result->finance->status =='معلق')
                <span class="badge badge-pill bg-dark m-1 font-weight-light">معلق</span>
            @else
                <span class="badge badge-pill bg-success m-1 font-weight-light">{{$result->finance->status}}</span>
            @endif

            @if(isset($result->FinotechSendMoney))
                <span class="font-weight-bold">(پرداخت شده اتوماتیک از فینوتک)</span>
            @endif
        </p>
        @if(isset($result->finance->traceNumber))
            <p class="mb-0">
                <strong>کد رهگیری:</strong>
                <span>{{$result->finance->traceNumber}}</span>
            </p>
        @endif

        <p class="mb-0">
            <strong>آی پی:</strong>
            {{$result->finance->ip ?? '----'}}
        </p>
        @if(isset($result->admin))
            <br>
            <b>تغییر توسط:</b>
            <a href="{{asset('').env('PanelPrefix')}}/admins/{{$result->admin->id}}">{{$result->admin->name. ' '.$result->admin->email}}</a>
            <br>
            <b>تاریخ تغییر:</b>
            {{$result->update}}
        @endif

        @if(isset($result->FinotechSendMoney))
            <br>
            <b class="text-primary">پرداخت شده اتوماتیک توسط فینوتک</b>
        @endif
    </div>
</div>

<hr width="20%">

<div class="row">
    <div class="col-md-6">
        <h5>مشخصات مشتری: </h5>
        <p class="mb-1"><a href="{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}" class="typo_link text-primary"><i class="ft-link"></i> {{$result->user->name .' '.$result->user->family}}</a></p>
        <p class="">{{$result->user->address}}</p>
    </div>
    <div class="col-md-6">
        <h5>اطلاعات تماس مشتری: </h5>
        <p class="mb-1">موبایل: {{$result->user->mobile}}</p>
    </div>
</div>
<hr width="30%">
<div class="row">
    <div class="col-md-12 text-left">
        <h5>توضیحات: </h5>
        <p class="mb-1">{{$result->finance->description}}</p>

    </div>
    <div class="col-md-12 mt-3 text-left">
        <h5>توضیحات مشتری: </h5>
        <p class="mb-1">{{$result->finance->user_description}}</p>
    </div>
</div>
<hr width="40%">


@if($result->finance->status=='معلق,پرداخت شده')
    <p class="text-center">
        این تراکنش به علت اینکه از کارتی غیر از کارت های تایید شده، پرداخت شده است به کیف پول کاربر افزوده نشده و جهت پیگیری مبلغ واریز شده به تیکتی که اتوماتیک ایجاد شده است مراجعه نمایید.
    </p>
    <div class="text-center">
        <button type="button" class="btn btn-info btn-round m-1" onclick="return_amount()">عودت</button>
    </div>
@elseif($result->finance->status=='معلق,عودت')
    <p class="text-center">
        این تراکنش به علت اینکه از کارتی غیر از کارت های تایید شده، پرداخت شده است به کیف پول کاربر افزوده نشده و اکنون توسط ادمین <b>مبلغ تراکنش به کیف پول کاربر با موفقیت اضافه شد.</b>
    </p>
@elseif($result->finance->status=='ناموفق')
    <p class="text-center">
        این تراکنش به علت اینکه از کارتی غیر از کارت های تایید شده، پرداخت شده است به کیف پول کاربر افزوده نشده و مبلغ حداکثر تا 72 ساعت آینده به حسابی که پرداخت کرده است برمیگردد جهت پیگیری به تیکتی که اتوماتیک ایجاد شده است مراجعه نمایید.
    </p>
@elseif($result->finance->status=='معلق')
    <p class="text-center">
        کاربر به درگاه رفته است و پرداخت را انجام نداده است.
    </p>
    @if(date("Y-m-d H:i:s") > date("Y-m-d H:i:s",strtotime('+15 minutes',strtotime($result->finance->created_at))))
        <div class="text-center">
            <button type="button" class="btn btn-danger btn-round m-1" onclick="remove()">حذف</button>
        </div>
    @endif
@elseif($result->finance->status=='در دست اقدام' | $result->finance->status=='رد شده' | $result->finance->status=='واریز شده')
    @if($result->finance->status=='در دست اقدام')
        <p class="text-center">
            این تراکنش در دست اقدام میباشد و بعد از بررسی میتوانید تایید و یا رد نمایید.
        </p>
        <div class="text-center">
            <button type="button" class="btn btn-success btn-round m-1" onclick="confirm()">تایید و واریز شد</button>
            <button type="button" class="btn btn-danger btn-round m-1" onclick="reject()">رد کردن</button>
        </div>
        <hr width="70%">
    @endif
    <div class="row text-left">
        <div class="col-md-4">
            <p class="font-weight-bold">نام بانک:</p>
        </div>
        <div class="col-md-8 text-center">
            <p>{{$result->cardbank->bank_name??''}}</p>
        </div>

        <div class="col-md-4">
            <p class="font-weight-bold">شماره کارت:</p>
        </div>
        <div class="col-md-8 text-center">
            <p>{{$result->cardbank->card_number??''}}</p>
        </div>

        <div class="col-md-4">
            <p class="font-weight-bold">شماره حساب:</p>
        </div>
        <div class="col-md-8 text-center">
            <p>{{$result->cardbank->account_number??''}}</p>
        </div>

        <div class="col-md-4">
            <p class="font-weight-bold">شماره شبا:</p>
        </div>
        <div class="col-md-8 text-center" >
            <p>{{$result->cardbank->shaba??''}}</p>
        </div>

    </div>

@endif


<script>
    var url =$('meta[name=url]').attr("content");

    function confirm(){
        Swal.fire({
            title: "از تایید اطمینان دارید؟",
            type:'question',
            html:
                'بعد از تایید سفارش امکان رد کردن آن وجود ندارد! همچنین میتوانید مبلغ پرداختی را تغییر دهید. و اگر تیک اتوماتیک را نزده باشید میبایست ابتدا به صورت دستی مبلغ را به حساب کاربر واریز نمایید و سپس تایید کنید' +
                '<select class="swal2-input p-0" id="swal-input1" required>'+
                '<option selected value="شبا">شبا</option>'+
                '<option value="کارت به کارت">کارت به کارت</option>'+
                '<option value="واریز">واریز</option>'+
                '</select>'+
                '<fieldset><fieldset><div class="vs-checkbox-con vs-checkbox-primary"><input type="checkbox" value="true" id="swal-input2">'+
                '<label class="" for="swal-input2"> <span class="mx-1">اتوماتیک از api واریز شود؟</span> </label></div></fieldset>',

            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            showLoaderOnConfirm: true,
            confirmButtonText: "آره",
            confirmButtonColor:"#009904",
            cancelButtonText: "نه",
            preConfirm: () => {
                if ( $('#swal-input2').is(':checked') )
                    autoDeposit = true;
                else
                    autoDeposit = false;

                return $.ajax({
                    url: url+"/finances/{{$result->finance->id}}/confirm",
                    type: 'put',
                    data: {_token: "{{ csrf_token() }}",via:$('#swal-input1').val(),autoDeposit:autoDeposit},
                });
            }
        }).then((data) => {
            if(data.value.status==true){
                Swal.fire({
                    title:'انجام شد!',
                    type: 'success',
                    text: data.value.messege,
                }).then(function () {
                    $('.alt-pagination').DataTable().ajax.reload();
                    $("#Info").modal('hide');
                });
            }
            else{
                Swal.fire("خطا",  data.value.message  , "error");
            }
        });
    }


    function reject(){
        Swal.fire({
            title: "از رد کردن اطمینان دارید؟",
            text: "جهت رد کردن دلیلی را مشخص نمایید",
            type: "info",
            input: 'text',
            inputPlaceholder: 'دلیل رد شدن را ذکر کنید',
            showCancelButton: true,
            showLoaderOnConfirm: true,
            confirmButtonText: "آره",
            confirmButtonColor:"#991008",
            cancelButtonText: "نه",
            inputValidator: (value) => {
                if (!value) {
                    return 'دلیل رد شدن را درج کنید'
                }
            },
            preConfirm: (value) => {
                return $.ajax({
                    url: url+"/finances/{{$result->finance->id}}/reject",
                    type: 'put',
                    data: {_token: "{{ csrf_token() }}",reason:value},
                });
            }
        }).then((data) => {
            if(data.value.status==true){
                Swal.fire({
                    title:'انجام شد!',
                    type: 'success',
                    text: data.value.message,
                }).then(function () {
                    $('.alt-pagination').DataTable().ajax.reload();
                    $("#Info").modal('hide');
                });
            }
            else{
                Swal.fire("خطا",  data.value.message  , "error");
            }
        });
    }



    function return_amount(){
        Swal.fire({
            title: "از عودت اطمینان دارید؟",
            text: "اگر کیف پول را انتخاب کنید مبلغ اتوماتیک به کیف پول کاربر اضافه میشود",
            type: "info",
            input: 'checkbox',
            inputPlaceholder: 'آیا به کیف پول واریز شود؟',
            showCancelButton: true,
            showLoaderOnConfirm: true,
            confirmButtonText: "آره",
            confirmButtonColor:"#00d213",
            cancelButtonText: "نه",
            preConfirm: (input) => {
                return $.post(url+"/finances/{{$result->finance->id}}/return-amount",
                    {
                        block:"0",
                        wallet:input,
                        _token: "{{ csrf_token() }}"
                    });

            }
        }).then((data) => {
            if(data.value.status==true){
                Swal.fire({
                    title:'انجام شد!',
                    type: 'success',
                    text: data.value.messege,
                }).then(function () {
                    location.reload();
                });
            }
            else{
                Swal.fire("خطا",  data.value.messege  , "error");
            }
        });
    }


    function remove(){
        Swal.fire({
            title: "از حدف اطمینان دارید؟",
            type: "info",
            showCancelButton: true,
            showLoaderOnConfirm: true,
            confirmButtonText: "آره",
            confirmButtonColor:"#d22346",
            cancelButtonText: "نه",
            preConfirm: () => {
                return $.ajax({
                    url: url + "/finances/{{$result->finance->id}}/remove",
                    type: 'DELETE',
                    data: {_token: "{{ csrf_token() }}"},
                });
            }
        }).then((data) => {
            if(data.value.status==true){
                Swal.fire({
                    title:'انجام شد!',
                    type: 'success',
                    text: data.value.messege,
                }).then(function () {
                    $('.alt-pagination').DataTable().ajax.reload();
                    $('.modal').modal('hide')
                });
            }
            else{
                Swal.fire("خطا",  data.value.messege  , "error");
            }
        });
    }
</script>


