@extends('admin.layouts.master')
@section('title', 'سفارشات پول الکترونیک')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0 font-size-18">لیست سفارشات</h4>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="card-title mb-3">سفارشات</div>
                <div class="row justify-content-between">
                    <div class="col-md-3">
                        <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle table-nowrap table-check">
                        <thead class="table-light">
                            <tr>
                                <th>لوگو</th>
                                <th class="align-middle">نام ارز</th>
                                <th class="align-middle">نام خریدار</th>
                                <th class="align-middle">تاریخ</th>
                                <th class="align-middle">نوع سفارش</th>
                                <th class="align-middle">مبلغ پرداختی</th>
                                <th class="align-middle">وضعیت سفارش</th>
                                <th class="align-middle">روش پرداخت</th>
                                <th class="align-middle">مشاهده جزییات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $orders as $order )
                                <tr>
                                    <td><img src="{{asset($order->digitalMoney->logo)}}" width="25px" alt="product-img" title="product-img"/></td>
                                    <td>{{$order->digitalMoney->name_fa}}</td>
                                    <td><a href="{{ asset('').env('PanelPrefix') }}/users/{{ $order->user->id }}">{{ $order->user->name . ' ' . $order->user->family }}</a></td>
                                    <td>{{ $order->created_at }}</td>
                                    <td>
                                        @if( $order->order_type == 'buy' )
                                            خرید
                                        @else
                                            فروش
                                        @endif
                                    </td>
                                    <td>{{ number_format($order->final_price) }}<small class="ms-1">تومان</small></td>
                                    <td>
                                        @if( $order->status == 'confirm' )
                                            <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                        @elseif( $order->status == 'pending' )
                                            <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                        @elseif( $order->status == 'canceled' )
                                            <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if( $order->payment_type == 'wallet' )
                                            <span>کیف پول</span>
                                        @else
                                            <span>کارت به کارت</span>
                                        @endif
                                    </td>
                                    <td>
                                        <!-- Button trigger modal -->
                                        <button type="button" data-bs-toggle="modal" data-bs-target=".order-{{$order->id}}" class="btn btn-primary btn-sm btn-rounded">
                                            مشاهده
                                        </button>

                                        <div class="modal fade order-{{$order->id}}" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id=myLargeModalLabel">جزییات سفارش</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p class="mb-2">شناسه سفارش: <span class="text-primary">{{$order->id}}</span></p>
                                                        <p class="mb-2">نوع سفارش:
                                                            <span class="badge badge-pill badge-soft-warning">
                                                            @if($order->order_type == 'buy')
                                                                    خرید
                                                                @else
                                                                    فروش
                                                                @endif
                                                        </span>
                                                        </p>
                                                        <p class="mb-2">سفارش دهنده:
                                                            <span class="text-primary">
                                                            <a href="{{ asset('').env('PanelPrefix') }}/users/{{ $order->user->id }}">{{ $order->user->name . ' ' . $order->user->family }}</a>
                                                         </span>
                                                        </p>
                                                        <p class="mb-2">تاریخ: <span>{{$order->created_at}}</span></p>
                                                        <p class="mb-2">وضعیت سفارش:
                                                            @if( $order->status == 'confirm' )
                                                                <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                                            @elseif( $order->status == 'pending' )
                                                                <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                            @elseif( $order->status == 'canceled' )
                                                                <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                                            @endif
                                                        </p>
                                                        <p class="mb-4">روش پرداخت:
                                                            @if( $order->payment_type == 'wallet' )
                                                                <span>کیف پول</span>
                                                            @else
                                                                <span>کارت به کارت</span>
                                                            @endif
                                                        </p>
                                                        <p class="mb-2">کد پیگری: <span class="badge badge-pill badge-soft-warning">{{$order->tracking_code }}</span></p>
                                                        <p class="mb-2">آدرس کیف پول:
                                                            <span class="text-primary">
                                                            {{$order->wallet_currency == null ? 'کیف پول سایت' : $order->wallet_currency}}
                                                        </span>
                                                        </p>
                                                        <div class="table-responsive mb-3">
                                                            <table class="table align-middle table-nowrap">
                                                                <thead>
                                                                <tr>
                                                                    <th scope="col">لوگو</th>
                                                                    <th scope="col">نام ارز</th>
                                                                    <th scope="col">تعداد</th>
                                                                    <th scope="col">قیمت</th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <tr>
                                                                    <th scope="row">
                                                                        <div>
                                                                            <img src="{{asset($order->digitalMoney->logo)}}" alt="logo" class="avatar-sm">
                                                                        </div>
                                                                    </th>
                                                                    <td>
                                                                        <div>
                                                                            <h5 class="text-truncate font-size-14">{{$order->digitalMoney->name_fa}}</h5>
                                                                        </div>
                                                                    </td>
                                                                    <td>{{$order->quantity}}</td>
                                                                    <td>{{$order->currency_price}}<small class="ms-1">تومان</small></td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2">
                                                                        <h6 class="m-0 text-right">مجموع:</h6>
                                                                    </td>
                                                                    <td></td>
                                                                    <td>{{$order->final_price }}<small class="ms-1">تومان</small></td>
                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        <div class="mt-2">
                                                            <label class="mb-1 font-weight-bold">توضیحات کاربر برای شما </label>
                                                            <textarea class="form-control" rows="2" disabled>{{$order->description}}</textarea>
                                                            <hr>
                                                            <label class="mb-1 font-weight-bold">توضیحات شما برای کاربر</label>
                                                            <p class="text-muted mb-2">شما می توانید اطلاعات مورد نیاز برای محصول مانند آدرس کیف پول ارز مورد نظر را برای کاربر <br> در قسمت پایین بنویسید تا کاربر از بخش سفارشات مشاهده کند.</p>
                                                            @if($order->status == 'confirm')
                                                                <textarea class="form-control" rows="2" disabled></textarea>
                                                            @else
                                                                <form autocomplete="off" action="?type=active&id={{$order->id}}" method="POST">
                                                                    @csrf
                                                                  <textarea  name="admin_note" id="note" class="form-control" rows="2"></textarea>
                                                                    <div class="modal-footer">
                                                                        @if($order->status == 'pending')
                                                                            <button type="submit" class="btn btn-success">تکمیل سفارش</button>
                                                                        @endif
                                                                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">بستن</button>
                                                                    </div>
                                                                </form>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                {{ $orders->links() }}
            </div>
        </div>
    </div>
</div>


@stop

@section('script')
    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });
    </script>
@stop
