@extends('admin.layouts.master')
@section('title', 'سفارشات در انتظار بررسی')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارشات در انتظار بررسی</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">سفارشات در انتظار بررسی</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>نام مشتری</th>
                            <th>ارز</th>
                            <th>نوع سفارش</th>
                            <th>مقدار</th>
                            <th>تاریخ و ساعت ثبت</th>
                            <th>وضعیت</th>
                            <th>مبلغ سفارش</th>
                            <th>جزئیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($orders as $order)
                            <tr>
                                <td>{{ $order->id }}</td>
                                <td>{{ $order->name .' '. $order->family }}</td>
                                <td>
                                    <img class="me-1" src="{{asset('')}}app-assets/images/currency/{{ $order->coin }}.svg" width="25px">
                                </td>
                                <td>{{ $order->orders_model }}</td>
                                <td>{{ $order->amount_coin }}</td>
                                <td>{{ $order->created_at }}</td>
                                <td>{{ $order->status }}</td>
                                <td>{{ $order->payment }}</td>
                                <td>
                                    <a class="btn btn-light" href="{{ asset('').env('PanelPrefix') }}/orders/{{ $order->id }}">جزییات</a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop
