<?php



namespace App\Http\Middleware;
use Auth;

use Closure;



class Access

{

    /**

     * Handle an incoming request.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  \Closure  $next

     * @return mixed

     */

    public function handle($request, Closure $next){

        if(Auth::guard('admin')->check()){
            $user = Auth::guard('admin')->user();
            if($user->access!=1){
                Auth::guard('admin')->logout();
                return redirect('A-login');
            }else
                return $next($request);

        }else{
		   $user = Auth::user();
		   $ip = $request->ip();
		   $IP_Access = getSetting('IP_Access');
		   $IP_Iran = getSetting('IP_Iran');

		   if($IP_Iran == 'on'){
               $ipinfo = \Location::get($ip);
               if($ipinfo != false && $ipinfo->countryCode != 'IR'){
                   return \Response::view('errors.IpIran');
               }
           }

		   if($IP_Access!='' && $IP_Access != $ip){
                return \Response::view('errors.IpAccess');
		   }

		   if($user->access==1)
				return $next($request);
		   else{
               Auth::logout();
               return redirect('login');
		   }
       }

    }

}

