<?php

namespace App\Http\Controllers\User;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali;
use DB;
use Session;
use Auth;
use App\UserInvitation;

class InvitationController extends Controller
{
    public function index(){
        $result = array();

        $invitationUsers = User::select('id','name','family','created_at')->where('invitationID',Auth::user()->id)->orderBy('id','desc')->get();
        foreach($invitationUsers as $user){
            $user->date =  Jalali\CalendarUtils::strftime('d F Y', strtotime($user->created_at));
            $user->order = \App\Orders::where('id_user',$user->id)->where('type','!=','sell')
                                        ->where('type','!=','sell')->whereNotNull('payment')->count();
        }
        $result['invitationUser'] = $invitationUsers;
        $result['orders'] = UserInvitation::where('id_user',Auth::user()->id)->orderBy('created_at','desc')->count();
        $result['amount'] = UserInvitation::where('id_user',Auth::user()->id)->orderBy('created_at','desc')->sum('amount');

        return view('user.invitation',['result'=>(object)$result]);
    }

    public function list_orders(){

        $result["data"] = array();
        $UserInvitation = UserInvitation::where('id_user',Auth::user()->id)->orderBy('created_at','desc')->get();

        foreach($UserInvitation as $Invitation):

            $user = User::select('name','family')->find($Invitation->id_invitation_user);
            $array["2"] = $user->name .' '.$user->family;
            $array["3"] = number_format($Invitation->amount). ' تومان';
            $array["4"] = Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($Invitation->created_at));

            array_push($result["data"], $array);
        endforeach;
        return response()->json($result);
    }
}
