<?php

namespace App\Http\Controllers\Admin;

use App\UserInvitation;
use http\Env;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali;
use DB;
use Image;
use App\functions;
use SoulDoit\DataTable\SSP;
use Kavenegar;
use Telegram\Bot\Api;

class UsersController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if(Auth::user()->access_users ==1 || Auth::user()->role == 'admin')
                return $next($request);
            else
                abort(404);
        });
    }

    public function index(){

        $functions = new \App\functions;
        $users = \App\User::select('id','name','family','code_meli','mobile','created_at','updated_at','wallet','auth_img_confirm','selfie_img_confirm','phone')
            ->latest('created_at')
            ->paginate(10);
        foreach ($users as $user) {
            $user->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($user->created_at));
        }

        return view('admin.users', ['users'=>$users]);
    }

    public function single(Request $request){

        $result = (object)array();
        $user = User::find($request->id);
        //dd($user);
        if(!$user)
            abort(404);

        if(isset($user->invitationID)){
            $invitation = User::find($user->invitationID);
            $user->invitation = $invitation->mobile;
            $user->invitationName = $invitation->name.' '.$invitation->family;
        }

        $result->user = $user;

        $ostan = \App\provinces::all();

        if ($user->id_province) {
            $province = \App\provinces::find($user->id_province);
            $cities = $province->cities()->select('id', 'title')->get();
        }
        $result->ostan = isset($ostan) ? $ostan : array();
        $result->city = isset($cities) ? $cities : array();

        $result->card = \App\CardBank::where('id_user',$user->id)->orderBy('id','desc')->get();
        foreach ($result->card as $card){
            $card->date = Jalali\CalendarUtils::strftime('Y/m/d - H:i', strtotime($card->created_at));
            if($card->id_admin){
                $card->admin = \App\AdminUser::find($card->id_admin);
            }
        }

        $result->wallet = \App\Wallet::where('id_user', $user->id)->orderBy('id','desc')->get();
        foreach ($result->wallet as $wallet){
            $wallet->date = Jalali\CalendarUtils::strftime('Y/m/d - H:i', strtotime($wallet->created_at));
            if($wallet->id_admin){
                $wallet->admin = \App\AdminUser::find($wallet->id_admin);
            }
        }


        $Finances = \App\UserFinance::select('stock','created_at')->where('id_user',$user->id)->orderBy('id','desc')->limit(10)->get()->reverse();
        foreach($Finances as $finance):
            $finance->date =  Jalali\CalendarUtils::strftime('Y/m/d H:i', strtotime($finance->created_at));
        endforeach;
        $result->finance = $Finances;


        $invitationUsers = User::select('id','name','family','mobile','created_at')->where('invitationID',$user->id)->orderBy('id','desc')->get();
        foreach($invitationUsers as $user1){
            $user1->date =  Jalali\CalendarUtils::strftime('d F Y', strtotime($user1->created_at));
            $user1->order = \App\Orders::where('id_user',$user1->id)->where('type','!=','sell')->whereNotNull('payment')->count();
        }
        $result->invitationUser = $invitationUsers;


        $result->CountBuy = $Orders = \App\Orders::where('id_user',$user->id)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->
                                        whereRaw('(type = "buy" or type = "buy-product")')->count();
        $result->CountSell = $Orders = \App\Orders::where('id_user',$user->id)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->
                                        whereRaw('(type = "sell")')->count();

        $result->SumBuy = $Orders = \App\Orders::where('id_user',$user->id)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->
                                        whereRaw('(type = "buy" or type = "buy-product")')->sum('amount');
        $result->SumSell = $Orders = \App\Orders::where('id_user',$user->id)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->
                                        whereRaw('(type = "sell")')->sum('amount');


        if($user->auth_img_confirm_admin){
            $result->auth_img_confirm_admin = \App\AdminUser::find($user->auth_img_confirm_admin);
        }
        $result->ListNotify = \App\Notification::where('id_user',$user->id)->orderBy('id','desc')->get();
        foreach ($result->ListNotify as $Notify){
            $Notify->date = Jalali\CalendarUtils::strftime('d F Y H:i:s', strtotime($Notify->created_at));
        }

        /*
        $result->ListAuthStatus = \App\UserAuthStatus::where('id_user',$user->id)->orderBy('id','desc')->get();
        foreach ($result->ListAuthStatus as $AuthStatus){
            $AuthStatus->admin = \App\AdminUser::find($AuthStatus->id_admin)->name;
            $AuthStatus->date = Jalali\CalendarUtils::strftime('d F Y H:i:s', strtotime($AuthStatus->created_at));
        }*/

        return view('admin.users.user',['result'=>$result]);
    }

    public function block(Request $request){
        $validator = \Validator::make($request->all(), [
            'block' => 'required'
        ]);

        if($validator->fails()!=1):

            $user = User::where('id', $request->id)->update(['access' => $request->block,'access_reason' => $request->reason]);
            if($user){
                $result = array('status' => 'true' , 'messege' => 'با موفقیت تغییر کرد');
            }else
                $result = array('status' => 'false' , 'messege' => 'تغییر امکان پذیر نیست');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }


    function edit(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'family' => 'required',
            'email' => 'nullable|email',
            'codemeli' => 'nullable|numeric',
            'auth_img' => 'mimes:jpg,jpeg,png|nullable',
            'FatherName' => 'nullable|farsi',
        ]);
        if ($validator->fails() != 1):

            DB::beginTransaction();
            try {

                $user = User::where('id', $request->id)->first();
                if (isset($user)) :

                    $user->name = $request->name;
                    $user->family = $request->family;
                    $user->code_meli = $request->codemeli;
                    if(isset($request->password) && $request->password !='')
                        $user->password = bcrypt($request->password);
                    $user->mobile = $request->mobile;
                    $user->email = $request->email;
                    $user->father_name = $request->FatherName;
                    $user->date_birth = $request->DateBirth;
                    $user->phone = $request->phone;
                    $user->address = $request->address;
                    $user->id_province = $request->ostan;
                    $user->id_city = $request->city;

                    $directory = 'uploads/Users/' . $user->created_at->year . '/' . $user->created_at->month . '/' . $user->id;
                    if(isset($request->auth_img)){
                        $file = $request->file('auth_img');
                        $extension = $file->getClientOriginalExtension();
                        $just_name = str_replace(" ", "-", pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME));
                        $just_name_hash = str_replace("/", "", bcrypt($just_name . time() . 'meli'));
                        $name = $just_name_hash . '.' . $extension;

                        $old_auth_img = $user->auth_img;

                        $Image = Image::make($file);
                        if ($Image->width() > 1000) {
                            $Image->resize(1000, null, function ($constraint) {
                                $constraint->aspectRatio();
                            });
                        }
                        if ($Image->width() > 2000) {
                            $Image->resize(null, 2000, function ($constraint) {
                                $constraint->aspectRatio();
                            });
                        }

                        $file_path = $directory . '/' . $name;
                        if (!file_exists(($file_path))) {
                            \File::makeDirectory($directory, $mode = 0777, true, true);
                            if ($Image->save(($directory . '/' . $name))) {
                                $user->auth_img = $directory . '/' . $name;
                            }
                        } else {
                            if ($Image->save(($directory . '/' . $just_name_hash . time() . '.' . $extension))) {
                                $user->auth_img = $directory . '/' . $just_name_hash . time() . '.' . $extension;
                            }
                        }

                        if (file_exists(($old_auth_img)))
                            unlink($old_auth_img);
                    }

                    if(Auth::user()->role == 'admin')
                        $user->wallet = str_replace(',','',$request->wallet) ;


                    $user->daily_buy = str_replace(',','',$request->daily_buy);
                    if($request->twofa == '' ||$request->twofa == 'google2fa'){
                        $user->google2fa = null;
                        $user->sms2fa = 0;
                    }elseif($request->twofa == 'sms2fa'){
                        $user->google2fa = null;
                        $user->sms2fa = 1;
                    }

                    if(isset($request->invitation)){
                        $invitation = User::where('mobile',$request->invitation)->first();
                        $user->invitationID = $invitation->id;
                    }else{
                        $user->invitationID = null;
                    }

                    $functions = new \App\functions;
                    $functions->LogAdmin('تغییر در مشخصات: '.$user->mobile,'editUser');

                    $user->save();

                    DB::commit();
                    $result = array('status' => true, 'message' => 'ویرایش اطلاعات با موفقیت انجام شد.');
                else:
                    $result = array('status' => false, 'message' => 'کاربری موجود نیست');
                endif;
            } catch (\Exception $e) {
                DB::rollback();
                $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
            }


        else:
            $result = array('status' => false, 'message' => $validator->errors()->first());
            //$result = array('status' => false, 'message' => 'داده های درج شده درست نیست');
        endif;
        return response()->json($result);
    }


    public function cardbank_add(Request $request){
        $validator = \Validator::make($request->all(), [
            'bank_name' => 'required',
            'account_number' => 'nullable|numeric',
            'card_number' => 'required|numeric',
            'iban' => 'nullable|numeric',
            //'card_image' => 'required|mimes:jpg,jpeg,png',
        ], [
            'bank_name.required' => 'نام بانک را وارد نمایید',
            'name_family.required' => 'نام صاحب حساب را وارد نمایید',
            'card_number.required' => 'شماره کارت را وارد نمایید',
            'account_number.required' => 'شماره حساب را وارد نمایید',
            'iban.required' => 'شناسه شبا را وارد نمایید',
            'card_image.required' => 'تصویر کارت را وارد نمایید'
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        DB::beginTransaction();
        try {
            $user = User::find($request->id);
            $bank = new \App\CardBank;
            $bank->id_user =  $user->id;
            $bank->bank_name = $request->bank_name;
            //$bank->account_owner = $request->name_family;
            $bank->card_number = $request->card_number;
            $bank->account_number = $request->account_number;
            $bank->shaba = $request->iban;
            $bank->save();

            DB::commit();

            $result = array('status' => true, 'message' => 'کارت بانکی شما با موفقیت ثبت شد');

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
        }
        return response()->json($result);
    }


    public function cardbank(Request $request){
        $validator = \Validator::make($request->all(), [
            'id_card' => 'required|numeric',
            'status' => 'required'
        ]);

        if($validator->fails()!=1):
            $functions = new \App\functions;
            $user =  User::find($request->id);
            $CardBank = \App\CardBank::where('id_user', $request->id)->where('id', $request->id_card)->first();
            $CardBank->confirm = $request->status;
            $CardBank->id_admin = Auth::user()->id;
            if($CardBank->save()){
                if($request->status == 1){
                    $title = 'تایید کارت بانکی';
                    $body = 'کارت بانکی شما با موفقیت تایید شد.';
                   if($CardBank->via=='Telegram' && isset($user->telegram_id)){
                       $telegram = new Api(env('TelegramToken'));
                       $telegram->sendMessage(['chat_id' => $user->telegram_id,'text' => '✅ کارت بانکی شما با موفقیت تایید شد!' ]);
                   }
                   try{\Kavenegar::VerifyLookup($user->mobile,'.',null,null,'CardBankConfirm');} catch (\Exception $ex){}
                    $functions->LogAdmin('تایید کارت بانکی از '.$user->mobile.' با شماره '. $CardBank->card_number,'cardbank');

                }elseif($request->status == 3){
                    $title = 'رد کارت بانکی';
                    $body = 'کارت بانکی شما رد شد و برای درج کارت بانکی به قسمت کارت های بانکی مراجعه کنید!';
                    if($CardBank->via=='Telegram' && isset($user->telegram_id)){
                        $telegram = new Api(env('TelegramToken'));
                        $telegram->sendMessage(['chat_id' => $user->telegram_id,'text' => '⚠️ کارت بانکی شما رد شد و برای درج کارت بانکی به قسمت کارت های بانکی مراجعه کنید!' ]);
                    }
                    try{\Kavenegar::VerifyLookup($user->mobile,'.',null,null,'CardBankRejected');} catch (\Exception $ex){}

                    $functions->LogAdmin('رد کارت بانکی از '.$user->mobile.' با شماره '. $CardBank->card_number,'cardbank');

                }

                $date = Jalali\Jalalian::forge('today')->format('%d %B %Y');
                $data = array('date'=>$date, 'title'=>$title, 'body'=>$body);
                if(isset($user->email)){
                    \Mail::send('emails.notification', $data, function($message) use ($user)
                    {$message->to($user->email, $user->email)->subject('اطلاعیه از طرف '.env('APP_NAME_FARSI'));});
                }
                $functions->send_notification($title,$body,$user->firebase_token);

                $result = array('status' => 'true' , 'messege' => 'با موفقیت تغییر کرد');
            }else
                $result = array('status' => 'false' , 'messege' => 'تغییر امکان پذیر نیست');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }

    public function cardbank_info_modal(Request $request){
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");

        $CardBank = \App\CardBank::where('id_user', $request->id)->where('id', $request->id_card)->first();
        if($CardBank){
            $result = (object)array();
            $result->card = $CardBank;
            $result->user = User::find($request->id);
            return view('admin.users.cardbank-single',['result'=>$result]);
        }
    }

    public function cardbank_edit(Request $request){
        $validator = \Validator::make($request->all(), [
            //'name_family' => 'required',
            'bank_name' => 'required',
            'account_number' => 'nullable|numeric',
            'card_number' => 'required|numeric',
            'iban' => 'nullable|numeric',
            'card_image' => 'nullable|mimes:jpg,jpeg,png',
        ], [
            'bank_name.required' => 'نام بانک را وارد نمایید',
            'name_family.required' => 'نام صاحب حساب را وارد نمایید',
            'card_number.required' => 'شماره کارت را وارد نمایید',
            'account_number.required' => 'شماره حساب را وارد نمایید',
            'iban.required' => 'شناسه شبا را وارد نمایید',
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        DB::beginTransaction();
        try {
            $user = User::find($request->id);
            $bank = \App\CardBank::find($request->id_card);
            $bank->id_user =  $user->id;
            $bank->bank_name = $request->bank_name;
            $bank->account_owner = $request->name_family;
            $bank->card_number = $request->card_number;
            $bank->account_number = $request->account_number;
            $bank->shaba = $request->iban;
            $bank->save();

            DB::commit();


            $functions = new \App\functions;
            $functions->LogAdmin('تغییر کارت بانکی از '.$user->mobile.' با شماره '. $bank->card_number,'cardbank');

            $result = array('status' => true, 'message' => 'کارت بانکی شما با موفقیت ثبت شد');

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
        }
        return response()->json($result);
    }

    public function cardbank_delete(Request $request){
        $validator = \Validator::make($request->all(), [
            'id_card' => 'required|numeric',
        ]);

        if($validator->fails()!=1):

            $CardBank = \App\CardBank::where('id_user', $request->id)->where('id', $request->id_card)->first();
            $card_image = $CardBank->card_image;
            $id_user = $CardBank->id_user;
            try {
                if($CardBank->delete())
                    if (file_exists(($card_image)))
                        unlink($card_image);
                    $result = array('status' => 'true' , 'messege' => 'با موفقیت حذف شد');

            } catch (\Illuminate\Database\QueryException $e) {
                $result = array('status' => 'false' , 'messege' => 'حذف امکان پذیر نیست');
            }


            $user = User::find($id_user);
            $functions = new \App\functions;
            $functions->LogAdmin('حذف کارت بانکی از '.$user->mobile,'cardbank');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }

    public function wallet_add(Request $request){
        $validator = \Validator::make($request->all(), [
            'coin_name' => 'required',
            'wallet' => 'nullable|numeric',
        ], [
            'coin_name.required' => 'نام ارز را وارد نمایید',
            'wallet.required' => 'آدرس کیف پول را وارد نمایید'
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        DB::beginTransaction();
        try {
            $user = User::find($request->id);
            $bank = new \App\CardBank;
            $bank->id_user =  $user->id;
            $bank->coin_name = $request->coin_name;
            $bank->wallet = $request->wallet;
            $bank->save();

            DB::commit();

            $result = array('status' => true, 'message' => 'کیف پول شما با موفقیت ثبت شد');

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
        }
        return response()->json($result);
    }

    public function wallet(Request $request){
        $validator = \Validator::make($request->all(), [
            'id_wallet' => 'required|numeric',
            'status' => 'required'
        ]);

        if($validator->fails()!=1):
            $functions = new \App\functions;
            $user =  User::find($request->id);
            $wallet = \App\Wallet::where('id_user', $request->id)->where('id', $request->id_wallet)->first();
            $wallet->confirm = $request->status;
            $wallet->id_admin = Auth::user()->id;
            if($wallet->save()){
                $result = array('status' => 'true' , 'messege' => 'با موفقیت تغییر کرد');
            }else
                $result = array('status' => 'false' , 'messege' => 'تغییر امکان پذیر نیست');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }

    public function list_orders(Request $request){

        $result["data"] = array();
        $whereRaw = '';
        if(isset($request->model))
            $whereRaw .=' (type = "'.$request->model.'" or type = "buy-product")';
        if(isset($request->currency))
            $whereRaw .=' (orders_model = "'.$request->currency.'" )';

        $whereRaw = str_replace(') (',') and (', $whereRaw);

        if($whereRaw =='')
            $Orders = \App\Orders::where('id_user',$request->id)->orderBy('created_at','desc')->get();
        else
            $Orders = \App\Orders::where('id_user',$request->id)->whereRaw($whereRaw)->orderBy('created_at','desc')->get();

        $functions = new \App\functions;
        foreach($Orders as $order):

            $detail = $functions->get_order_detail($order->id);


            $array["2"] = $detail->type .' '. $detail->title;
            $array["9"] = '<img src="'.asset('').'app-assets/images/currency/'.$order->orders_model.'.svg" width="30px">';

            $array["3"] = $detail->amount_dollar ? $detail->amount_dollar : '' ;
            $array["8"] = $detail->amount_dollar ? $detail->dollar : '-----';
            $array["4"] = Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($order->created_at));
            if($order->status == 'پرداخت شده' || $order->status == 'انجام شده'){
                if($detail->amount_dollar)
                    $array["5"] = '<span class="badge badge-pill bg-success font-weight-light">'.$order->status.'</span>';
                else{
                    $array["5"] = '<span class="badge badge-pill bg-success font-weight-light">'.$order->status.'</span>';
                    $array["5"] .= ' <span class="badge badge-pill bg-danger font-weight-light">ناموفق</span>';
                }
            }
            elseif ($order->status == 'در دست اقدام')
                $array["5"] = '<span class="badge badge-pill bg-info font-weight-light">در دست اقدام</span>';
            elseif($order->status == 'رد شده')
                $array["5"] = '<span class="badge badge-pill bg-danger font-weight-light">'.$order->status.'</span>';
            elseif($order->status == 'معلق')
                $array["5"] = '<span class="badge badge-pill bg-dark font-weight-light">معلق</span>';
            else
                $array["5"] = '<span class="badge badge-pill bg-warning font-weight-light">'.$order->status.'</span>';

            $array["6"] = number_format($order->amount).' <span class="font-small-2">تومان</span> ';
            $array["7"] = '<a href="'.asset('').env('PanelPrefix').'/orders/'.$order->id.'" class="btn btn-outline-info round btn-sm">جزییات</a>';
            array_push($result["data"], $array);
        endforeach;
        return response()->json($result);
    }

    public function list_finance(Request $request){
        $result["data"] = array();
        $Finances = \App\UserFinance::where('id_user',$request->id)->orderBy('id','desc')->get();

        foreach($Finances as $finance):
            $array = array();
            $str = '';
            if($finance->id_order){
                $str = ' - سفارش';
            }
            if($finance->type == 'واریز'){
                $array["2"] = '<span class="text-success"><i class="mdi mdi-trending-up"></i> '.$finance->type.$str.' </span>';
                $array["3"] = '+';
            }
            else{
                $array["2"] = '<span class="text-danger"><i class="bx bx-trending-down"></i> '.$finance->type.$str.' </span>';
                $array["3"] = '-';
            }

            $array["3"] = number_format($finance->amount).$array["3"]. ' تومان';
            $array["4"] = number_format($finance->stock). ' تومان';
            $array["5"] = Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($finance->created_at));
            $array["6"] = '<a href="'.asset('').env('PanelPrefix').'/orders/'.$finance->id_order.'">'.$finance->description.'</a>';

            if($finance->status =='در دست اقدام')
                $array["7"] = '<span class="badge badge-pill bg-warning m-1 font-weight-light">'.$finance->status.'</span>';
            else
                $array["7"] = '<span class="badge badge-pill bg-success px-2 m-1 font-weight-light">'.$finance->status.'</span>';
            array_push($result["data"], $array);
        endforeach;
        return response()->json($result);
    }


    public function add_finance(Request $request){
        $validator = \Validator::make($request->all(), [
            'type' => 'required',
            'amount' => 'required',
            'description' => 'required'
        ]);

        if($validator->fails()!=1):
            DB::beginTransaction();
            try {
                $user = User::find($request->id);

                $Finance = new \App\UserFinance;
                $Finance->type = $request->type;
                $Finance->amount = str_replace(',','',$request->amount);
                $Finance->description = $request->description;
                $Finance->description = $request->description;
                $Finance->user_description = 'تراکنش دستی از طرف ادمین';
                $Finance->id_user = $user->id;
                $Finance->id_admin = Auth::user()->id;

                if($request->type =='واریز'){
                    $Finance->stock =  $user->wallet + $Finance->amount;
                    User::find($user->id)->increment('wallet',$Finance->amount);
                }elseif($request->type =='برداشت'){
                    if($Finance->amount < $user->wallet){
                        $Finance->stock =  $user->wallet - $Finance->amount;
                        User::find($user->id)->decrement('wallet',$Finance->amount);
                    }else{
                        $result = array('status' => 'false' , 'message' => 'مبلغ بیشتر از موجودی کاربر است');
                        return response()->json($result);
                    }

                }

                if($Finance->save()){
                    $result = array('status' => true , 'message' => 'با موفقیت ثبت شد');
                    DB::commit();
                }else
                    $result = array('status' => 'false' , 'message' => 'ثبت با مشکل مواجه شد');

            } catch (\Exception $e) {
                DB::rollback();
                $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد');
            }

        else:
            $result = array('status' => 'false' , 'message' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }


    public function list_invitation(Request $request){
        $result["data"] = array();
        $UserInvitation = \App\UserInvitation::where('id_user',$request->id)->orderBy('created_at','desc')->get();
        $functions = new \App\functions;

        foreach($UserInvitation as $Invitation):
            $user = User::select('id','name','family','mobile')->find($Invitation->id_invitation_user);
            $array["2"] = $user->name .' '.$user->family;
            $array["3"] = '<a class="typo_link text-info" href="'.asset('').env('PanelPrefix').'/users/'.$user->id.'">'.$user->mobile.'</a>';

            $detail = $functions->get_order_detail($Invitation->id_order);
            $array["4"] = '<a class="typo_link text-info" href="'.asset('').env('PanelPrefix').'/orders/'.$Invitation->id_order.'">'.$detail->type .' '. $detail->title.'</a>';

            $array["5"] = number_format(\App\Orders::find($Invitation->id_order)->amount). ' تومان';
            $array["6"] = number_format($Invitation->amount). ' تومان';
            $array["7"] = Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($Invitation->created_at));

            array_push($result["data"], $array);
        endforeach;
        return response()->json($result);
    }


    public function notification(Request $request)
    {
        $functions = new \App\functions;

        $user = User::find($request->id);

        $result = (object)array();
        $Notifi = new \App\Notification;
        $Notifi->title = $request->subject;
        $Notifi->message = $request->message;


        if(isset($request->sms)){
            $Notifi->sms = 1;
            if(isset($request->kavenegar)){
                $send_sms = $functions->KavehnegarSend($user->mobile,'.',$request->kavenegar);
                if ($send_sms->status != 200){
                    $result->status = false;
                    $result->message = 'پیامک از کاوه نگار ارسال نشد';
                    return response()->json($result);
                }
            }
            else{
                $sender = "10004346";
                Kavenegar::Send($sender,$user->mobile,$request->message);
            }

        }

        if(isset($request->email) && isset($user->email)){
            $Notifi->email = 1;
            $date = Jalali\Jalalian::forge('today')->format('%d %B %Y');
            $data = array('date'=>$date, 'title'=>$request->subject, 'body'=>$request->message);
            \Mail::send('emails.notification', $data, function($message) use ($user)
            {
                $message->to($user->email, $user->email)->subject('اطلاعیه از طرف '.env('APP_NAME_FARSI'));
            });

        }

        if(isset($request->notification)){
            $Notifi->notification = 1;
            $functions->send_notification($request->subject,$request->message,$user->firebase_token);
        }
        $Notifi->id_user = $user->id;
        $Notifi->save();

        $result->status = true;
        $result->message = 'با موفقیت ارسال شد';

        return response()->json($result);
    }


    public function user_delete(Request $request){

        $user = User::find($request->id);
        try {
            $tickets = \App\Ticket::where('id_user',$user->id)->get();
            foreach ($tickets as $ticket){
                $ticket_message = \App\TicketMessage::where('id_ticket',$ticket->id)->whereNotNull('file_link')->get();
                foreach($ticket_message as $message){
                    if (file_exists(($message->file_link)))
                        unlink($message->file_link);
                }
                \App\TicketMessage::where('id_ticket',$ticket->id)->delete();
            }
            \App\Ticket::where('id_user',$user->id)->delete();
            \App\UserFinance::where('id_user',$user->id)->delete();
            \App\CardBank::where('id_user',$user->id)->delete();
            \App\UserInvitation::where('id_user',$user->id)->delete();
            \App\UserInvitation::where('id_invitation_user',$user->id)->delete();
            \App\Notification::where('id_user',$user->id)->delete();
            \App\Wallet::where('id_user',$user->id)->delete();
            \App\ProductOrder::where('user_id',$user->id)->delete();
            \App\ProductOrderHistory::where('user_id',$user->id)->delete();
            \App\ProductOrderTransaction::where('user_id',$user->id)->delete();

            $Orders = \App\Orders::where('id_user',$user->id)->get();
            foreach ($Orders as $order){
                try {
                DB::table('orders_'.strtolower($order->orders_model))->where('id_order',$order->id)->delete();
                }catch(\Throwable $ee){}
            }
            \App\Orders::where('id_user',$user->id)->delete();


            $directory = 'uploads/Users/'.$user->created_at->year.'/'.$user->created_at->month.'/'. $user->id;
            \File::deleteDirectory($directory);

            if($user->delete())
                $result = array('status' => 'true' , 'messege' => 'با موفقیت حذف شد');

        } catch (\Illuminate\Database\QueryException $e) {
            $result = array('status' => 'false' , 'messege' => 'حذف امکان پذیر نیست');
        }
        return response()->json($result);
    }

    public function change_daily_buy(Request $request){
        $validator = \Validator::make($request->all(), [
            'daily_buy' => 'required',
        ]);

        if($validator->fails()!=1):
            $functions = new \App\functions;

            $user = User::find($request->id);
            $user->daily_buy = $request->daily_buy;
            if($user->save()){
                try{\Kavenegar::VerifyLookup($user->mobile,number_format($request->daily_buy),null,null,'ChangeDailyBuy');} catch (\Exception $ex){}

                $date = Jalali\Jalalian::forge('today')->format('%d %B %Y');
                $title ='تغییر سقف مجاز خرید روزانه';
                $body ='سقف خرید روزانه شما به مبلغ '.number_format($request->daily_buy).' تومان تغییر یافت.';

                if($user->email){
                    $data = array('date'=>$date, 'title'=>$title, 'body'=>$body);
                    \Mail::send('emails.notification', $data, function($message) use ($user)
                    {
                        $message->to($user->email, $user->email)->subject('اطلاعیه از طرف '.env('APP_NAME_FARSI'));
                    });
                }
                $functions->send_notification($title,$body,$user->firebase_token);

                $result = array('status' => 'true' , 'messege' => 'با موفقیت تغییر کرد');
            }else
                $result = array('status' => 'false' , 'messege' => 'تغییر امکان پذیر نیست');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }



    public function imagesConfirm(Request $request){
        $validator = \Validator::make($request->all(), [
            'status' => 'required|numeric',
            'image' => 'required'
        ]);
        $functions = new \App\functions;

        if($validator->fails()!=1):
            $user =  User::find($request->id);
            $user->{$request->image.'_confirm'} = $request->status;
            $user->{$request->image.'_reason'} = $request->reason;


            if($request->image == 'auth_img'){
                try{
                    $template = str_replace('_','',$request->image);
                    if ($request->status == 1){
                        $title = 'تایید اطلاعات پروفایل';
                        $body = 'اطلاعات حساب کاربری شما با موفقیت تایید شد.';
                        \Kavenegar::VerifyLookup($user->mobile,'.',null,null,$template.'Confirm');

                    }
                    else{
                        $title = 'عدم تایید اطلاعات پروفایل';
                        $body = 'متاسفانه اطلاعات حساب کاربری شما به دلیل '.$request->reason .' تایید نشد.';
                        \Kavenegar::VerifyLookup($user->mobile,'.',null,null,$template.'Rejected');
                    }

                    $date = Jalali\Jalalian::forge('today')->format('%d %B %Y');
                    $data = array('date'=>$date, 'title'=>$title, 'body'=>$body);
                    if($user->email){
                        \Mail::send('emails.notification', $data, function($message) use ($user)
                        {
                            $message->to($user->email, $user->email)->subject('اطلاعیه از طرف '.env('APP_NAME_FARSI'));
                        });
                    }
                    $functions->send_notification($title,$body,$user->firebase_token);
                }
                catch (\Exception $ex){}
            }
            $user->save();

            $result = array('status' => 'true' , 'messege' => 'با موفقیت تغییر کرد');

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }

    function finnotech_card(Request $request){
        $validator = \Validator::make($request->all(), [
            'id_card' => 'required',
            'model' => 'required',
        ]);

        if($validator->fails()!=1):
            $functions = new \App\functions;
            $Finnotech_Token = $functions->GetTokenFinotech();

            $CardBank = \App\CardBank::where('id_user', $request->id)->where('id', $request->id_card)->first();
            $authorization = "Authorization: Bearer ".$Finnotech_Token;

            if($request->model =='iban') {
                $url = "https://apibeta.finnotech.ir/facility/v2/clients/" . env('FinotechClientId') . "/cardToIban?trackId=" . time() . "&card=" . $CardBank->card_number;
                $responce = $functions->Curl($url, array(), $authorization, 'GET');

                if (isset($responce->status) && $responce->status != 'FAILED') {
                    $responce = (object)$responce->result;
                    $CardBank->shaba = str_replace('IR', '', $responce->IBAN);
                    $CardBank->account_owner = $responce->depositOwners[0]->firstName . ' ' . $responce->depositOwners[0]->lastName;
                    $CardBank->account_number = str_replace('.', '', $responce->deposit);
                    $CardBank->save();
                    $result = array('status' => 'true', 'title' => '', 'messege' => 'با موفقیت دریافت و ویرایش شد!');
                } else {
                    if ( isset($responce->status))
                        $result = array('status' => 'false', 'title' => $responce->error->message, 'messege' => 'خطای فینوتک: ' . $responce->error->message);
                    else
                        $result = array('status' => 'false', 'title' => 'هیچ پاسخی دریافت نشد', 'messege' => 'زمان انتظار برای دریافت پاسخ به پایان رسید');
                }
            }else if($request->model =='ibanOther'){
                $url = 'https://apibeta.finnotech.ir/oak/v2/clients/'.env('FinotechClientId').'/ibanInquiry?trackId='. time() .'&iban=IR'.$CardBank->shaba;
                $responce = $functions->Curl($url,array(),$authorization,'GET');
                if(isset($responce->status) && $responce->status != 'FAILED'){
                    $responce = (object)$responce->result;
                    $CardBank->bank_name = $responce->bankName;
                    $CardBank->account_owner = $responce->depositOwners[0]->firstName . ' ' . $responce->depositOwners[0]->lastName;
                    $CardBank->save();
                    $result = array('status' => 'true' , 'title'=> 'انجام شد' ,'messege' => 'نام صاحب شبا: <span class="text-danger">'. $CardBank->account_owner  .'</span>');
                }else{
                    if ( isset($responce->status))
                        $result = array('status' => 'false', 'title' => $responce->error->message, 'messege' => 'خطای فینوتک: ' . $responce->error->message);
                    else
                        $result = array('status' => 'false', 'title' => 'هیچ پاسخی دریافت نشد', 'messege' => 'زمان انتظار برای دریافت پاسخ به پایان رسید');

                }

            }else{
                $url = 'https://apibeta.finnotech.ir/mpg/v2/clients/'.env('FinotechClientId').'/cards/'.$CardBank->card_number;
                $responce = $functions->Curl($url,array(),$authorization,'GET');

                if($responce->status != 'FAILED'){
                    $responce = (object)$responce->result;
                    $CardBank->account_owner = $responce->name;
                    $CardBank->save();
                    $result = array('status' => 'true' , 'title'=>$responce->description ,'messege' => 'نام صاحب کارت: <span class="text-danger">'. $responce->name  .'</span>');
                }else{
                    $result = array('status' => 'false' , 'title'=>$responce->error->message ,'messege' => 'خطای فینوتک: '.$responce->error->message);
                }
            }

        else:
            $result = array('status' => 'false' , 'messege' => 'خطا در ارسال پارامتر');
        endif;
        return response()->json($result);
    }


}
