<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use Morilog\Jalali;
use DB;
use Image;
use Auth;

class UserAddController extends Controller
{
    public function index(){
        return view('admin.users-add');
    }


    public function infoCardbank(Request $request){
        $result = (object)array();
        $functions = new \App\functions;
        $Finnotech_Token = $functions->GetTokenFinotech();
        $authorization = "Authorization: Bearer ".$Finnotech_Token;


        $url = "https://apibeta.finnotech.ir/facility/v2/clients/".env('FinotechClientId')."/cardToIban?trackId=".time()."&card=".$request->cardnumber ;
        $responce = $functions->Curl($url,array(),$authorization,'GET');
        if($responce->status != 'FAILED'){
            $responce = (object)$responce->result;
            $result->iban = str_replace('IR','',$responce->IBAN);
            $result->account_owner = $responce->depositOwners[0]->firstName.' '.$responce->depositOwners[0]->lastName;
            $result->account_number = str_replace('.','',$responce->deposit);
            $result->status = true;
            $result->messege = 'با موفقیت دریافت و ویرایش شد!'.'<br>'.'نام دارنده حساب:'.$result->account_owner;
        }else{
            $result = array('status' => false , 'title'=>$responce->error->message ,'messege' => 'خطای فینوتک: '.$responce->error->message);
        }
        return response()->json((object)$result);
    }


    function add(Request $request)
    {

        $validator = \Validator::make($request->all(), [
            'mobile' => 'required|numeric|mobile',
            'name' => 'required|farsi',
            'family' => 'required|farsi',
            'email' => 'nullable|email',
            'FatherName' => 'required|farsi',
            'codemeli' => 'required|numeric',
            'DateBirth' => 'required',
            'DateReg' => 'nullable',
            'auth_img_confirm' => 'required|numeric',
            'auth_img' => 'nullable|mimes:jpg,jpeg,png',
            //'CardBankList' => 'required',
        ]);
        if ($validator->fails() != 1):


            DB::beginTransaction();
            try {

                $functions = new \App\functions;

                $user = User::where('mobile', $request->mobile)->first();
                if(isset($user)){
                    $result = array('status' => false, 'message' => 'موبایل کاربر تکراری است و قبلا ثبت شده است');
                    return response()->json($result);
                }

                $user = User::where('email', $request->email)->whereNotNull('email')->first();
                if(isset($user)){
                    $result = array('status' => false, 'message' => 'ایمیل کاربر تکراری است و قبلا ثبت شده است');
                    return response()->json($result);
                }


                $user = new User();
                $user->mobile = $request->mobile;
                $user->name = $request->name;
                $user->family = $request->family;
                $user->code_meli = $request->codemeli;
                $user->password = bcrypt($request->codemeli);
                $user->email = $request->email;
                $user->phone = $request->phone;
                $user->father_name = $request->FatherName;
                $user->date_birth = $request->DateBirth;
                $user->auth_img_confirm = $request->auth_img_confirm;

                if (isset($request->DateReg)) {
                    $request->DateReg = $functions->toLatin($request->DateReg);
                    $request->DateReg = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d', $request->DateReg);
                    $user->created_at = $request->DateReg;
                }


                $daily_buy = getSetting('daily_buy_register');
                $user->daily_buy = $daily_buy;

                $user->save();

                $functions->LogAdmin('ثبت کاربر: '.$user->mobile,'addUser');

               // درج لیست کارت های کاربر
                foreach ($request->CardBankList as $cardbank){
                    if($cardbank['cardnumber'] != null){
                        $bank = new \App\CardBank;
                        $bank->id_user = $user->id;
                        $bank->bank_name = $cardbank['bank_name'];
                        $bank->card_number = $cardbank['cardnumber'];
                        $bank->account_number = $cardbank['account_number'];
                        $bank->shaba = $cardbank['iban'];
                        $bank->account_owner = $cardbank['account_owner'];
                        $bank->confirm = 1;
                        $bank->id_admin = Auth::user()->id;
                        $bank->save();
                    }
                }




                //درج تصویر احراز هویت
                $directory = 'uploads/Users/' . $user->created_at->year . '/' . $user->created_at->month . '/' . $user->id;
                if(isset($request->auth_img)){
                    $file = $request->file('auth_img');
                    $extension = $file->getClientOriginalExtension();
                    $just_name = str_replace(" ", "-", pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME));
                    $just_name_hash = str_replace("/", "", bcrypt($just_name . time() . 'meli'));
                    $name = $just_name_hash . '.' . $extension;

                    $Image = Image::make($file);
                    if ($Image->width() > 1000) {
                        $Image->resize(1000, null, function ($constraint) {
                            $constraint->aspectRatio();
                        });
                    }
                    if ($Image->width() > 2000) {
                        $Image->resize(null, 2000, function ($constraint) {
                            $constraint->aspectRatio();
                        });
                    }

                    $file_path = $directory . '/' . $name;
                    if (!file_exists(($file_path))) {
                        \File::makeDirectory($directory, $mode = 0777, true, true);
                        if ($Image->save(($directory . '/' . $name))) {
                            $user->auth_img = $directory . '/' . $name;
                        }
                    } else {
                        if ($Image->save(($directory . '/' . $just_name_hash . time() . '.' . $extension))) {
                            $user->auth_img = $directory . '/' . $just_name_hash . time() . '.' . $extension;
                        }
                    }
                }
                $user->save();

                DB::commit();
                $result = array('status' => true, 'message' => 'درج اطلاعات با موفقیت انجام شد.');

            } catch (\Exception $e) {
                DB::rollback();
                $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
            }


        else:
            $result = array('status' => false, 'message' => $validator->errors()->first());
            //$result = array('status' => false, 'message' => 'داده های درج شده درست نیست');
        endif;
        return response()->json($result);
    }


    function infoMobile(Request $request){
        $user = User::where('mobile',$request->mobile)->first();
        if($user){
            $result = array('status' => false, 'messege' => 'شماره موبایل کاربر تکراری است و از قبل موجود است');
        }else{
            $result = array('status' => true, 'messege' => 'شماره موبایل از قبل ثبت نشده است');
        }
        return response()->json($result);
    }
}
