<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AdminUser;
use PragmaRX\Google2FAQRCode\Google2FA;
use Auth;
use Session;

class ProfileController extends Controller
{
    public function index(){
        return view('admin.profile');
    }
    public function profile(Request $request){

        $admin = AdminUser::find(Auth::user()->id);
        if(Auth::user()->role == 'admin'){
            $admin->name = $request->name;
            $admin->email = $request->email;
            $admin->mobile = $request->mobile;
        }


        if(isset($request->password)){
            if($request->password == $request->re_password){
                $admin->password = bcrypt($request->password);
            }
            else {
                $result = array('status' => false, 'message' => 'کلمه عبور و تکرار کلمه عبور یکسان نیستند!');
                return response()->json($result);
            }
        }

        $functions = new \App\functions();
        $functions->LogAdmin('ویرایش پروفایل','editProfile');

        $admin->save();
        $result = array('status' => true, 'message' => 'با موفقیت تغییر یافت!');
        return response()->json($result);
    }



    function twofa()
    {
        $data = array();
        if (Auth::user()->google2fa == null){

            $google2fa = new Google2FA(new \BaconQrCode\Renderer\Image\SvgImageBackEnd());
            if(session()->has("secret"))
                $secret = session()->get("secret");
            else{
                $secret = $google2fa->generateSecretKey();
                session()->put("secret", $secret);
            }
            $data['goole2fa']['secret'] = $secret;
            $inlineUrl = $google2fa->getQRCodeInline(
                env('APP_NAME'),
                'mobile:'.Auth::user()->mobile,
                $secret
            );
            $data['goole2fa']['inlineUrl'] = $inlineUrl;

        }
        return view('admin.profile-2fa',$data);
    }

    function twofa_sms(Request $request)
    {
        $functions = new \App\functions();

        if($request->sms==1){
            $user = AdminUser::find(Auth::user()->id);
            $user->sms2fa = 1;
            $user->google2fa = null;
			$user->TwofaStatus = 'active';
            $user->save();
            $result = array('status' => true, 'message' => 'ورود دو مرحله ای از طریق پیامک با موفقیت فعال شد!');
            $functions->LogAdmin('فعال کردن ورود دو مرحله ای پیامک','sms2fa');
        }
        else{
            $user = AdminUser::find(Auth::user()->id);
            $user->sms2fa = 0;
			$user->TwofaStatus = 'active';
            $user->save();
            $functions->LogAdmin('غیر فعال کردن ورود دو مرحله ای پیامک','sms2fa');
            $result = array('status' => true, 'message' => 'ورود دو مرحله ای غیر فعال شد!');
        }

        return response()->json($result);
    }

    function twofa_google(Request $request)
    {
        $functions = new \App\functions();

        $google2fa = new Google2FA(new \BaconQrCode\Renderer\Image\SvgImageBackEnd());
        if(isset(Auth::user()->google2fa)){
            $valid = $google2fa->verifyKey(Auth::user()->google2fa, $request->code);
            if($valid==1){
                $user = AdminUser::find(Auth::user()->id);
                $user->google2fa = null;
				$user->TwofaStatus = 'active';
                $user->save();
                $result = array('status' => true, 'message' => 'ورود دو مرحله ای غیر فعال شد!');
                $functions->LogAdmin(' فعال کردن ورود دو مرحله ای گوگل','google2fa');

            }else{
                $result = array('status' => false, 'message' => 'کد اشتباه است!');
            }
        }
        else{
            $valid = $google2fa->verifyKey(Session::get("secret"), $request->code);
            if($valid==1){
                $user = AdminUser::find(Auth::user()->id);
                $user->google2fa = Session::get("secret");
                $user->sms2fa = 0;
				$user->TwofaStatus = 'active';
                $user->save();
                $result = array('status' => true, 'message' => 'ورود دو مرحله ای از طریق گوگل با موفقیت فعال شد!');
                $functions->LogAdmin(' غیر فعال کردن ورود دو مرحله ای گوگل','google2fa');

            }else{
                $result = array('status' => false, 'message' => 'کد اشتباه است!');
            }
        }
        return response()->json($result);
    }
}
