<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\KYCVerification;
use App\User;

class KYCManagementController extends Controller
{
    /**
     * Show pending KYC requests
     */
    public function index()
    {
        $pendingKYCs = KYCVerification::where('status', 'pending')
            ->with('user')
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.kyc.index', compact('pendingKYCs'));
    }

    /**
     * Show KYC details
     */
    public function show($id)
    {
        $kyc = KYCVerification::with('user')->findOrFail($id);
        
        return view('admin.kyc.show', compact('kyc'));
    }

    /**
     * Approve KYC
     */
    public function approve(Request $request, $id)
    {
        $kyc = KYCVerification::findOrFail($id);
        
        $kyc->status = 'approved';
        $kyc->verified_at = now();
        $kyc->admin_note = $request->note;
        $kyc->save();

        return back()->with('success', 'احراز هویت تأیید شد');
    }

    /**
     * Reject KYC
     */
    public function reject(Request $request, $id)
    {
        $request->validate([
            'note' => 'required|string'
        ]);

        $kyc = KYCVerification::findOrFail($id);
        
        $kyc->status = 'rejected';
        $kyc->admin_note = $request->note;
        $kyc->save();

        return back()->with('success', 'احراز هویت رد شد');
    }

    /**
     * Get all KYC requests
     */
    public function all()
    {
        $kycs = KYCVerification::with('user')
            ->orderBy('created_at', 'desc')
            ->paginate(50);

        return view('admin.kyc.all', compact('kycs'));
    }
}
