<?php

namespace App\Http\Controllers\Admin;

use App\Category;
use App\ProductOrder;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\User;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Morilog\Jalali;
use App\functions;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function index()
    {
        $categories = Category::query()
            ->select('id','title','description','active','created_at')
            ->orderBy('created_at', 'desc')
            ->get();

        return view('admin.shop.categories', ['categories' => $categories]);
    }

    public function single($categoryId)
    {
        $category = Category::query()->find($categoryId);

        return response()->json(['data' => $category]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $categoryId = $request->id;

        $validator = Validator::make($request->all(), [
            'title' => [
                'required',
                'max:255',
                Rule::unique('categories')->ignore($categoryId),
            ],
            'active' => 'required',
            'description' => 'nullable',
        ], [
            'title.required' => 'عنوان دسته را وارد کنید.',
            'title.max' => 'عنوان دسته باید حداکثر :max کاراکتر باشد.',
            'title.unique' => 'این عنوان قبلا ثبت شده است.',
            'active.required' => 'وضعیت دسته‌بندی را مشخص نمایید.',
        ]);

        if($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        DB::beginTransaction();
        try {
            if(isset($categoryId))
                $category = Category::query()->find($categoryId);
            else
                $category = new \App\Category();

            $category->title = $request->title;
            $category->active = $request->active;
            $category->description = $request->description;
            $category->save();

            DB::commit();

            $result = array('status' => true, 'message' => 'دسته‌بندی با موفقیت ایجاد شد.');

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد!' . $e);
        }
        return response()->json($result);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $category = Category::query()->find($request->id);

        try {
            if($category->delete())
                $result = array('status' => true , 'messege' => 'با موفقیت حذف شد');
        } catch (\Illuminate\Database\QueryException $e) {
            $result = array('status' => false , 'messege' => 'حذف امکان پذیر نیست');
        }

        return response()->json($result);
    }
}
