<?php

namespace App\Http\Controllers\Admin;

use App\functions;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use SoulDoit\DataTable\SSP;
use Morilog\Jalali;

class CardBankController extends Controller
{
    public function index(){

        $functions = new \App\functions;
        $cardbanks = \App\CardBank::select('users_cardbank.id','users_cardbank.card_number','users_cardbank.id_user','users_cardbank.bank_name','users_cardbank.account_number','users_cardbank.created_at','users_cardbank.confirm','users_cardbank.updated_at','users.name','users.family')
            ->leftJoin('users', 'users_cardbank.id_user', '=', 'users.id')
            ->latest('updated_at')
            ->paginate(10);
        foreach ($cardbanks as $cardbank) {
            $cardbank->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($cardbank->created_at));
            $cardbank->updated_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($cardbank->updated_at));
        }

        return view('admin.cardbank', ['cardbanks'=>$cardbanks]);
    }
}
