<?php

namespace App\Http\Controllers\Admin\AdminAuth;

use App\AdminUser;
use App\Helpers\Sms\SmsIr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use PragmaRX\Google2FAQRCode\Google2FA;
use Session;

class LoginController extends Controller
{
    function index()
    {
        if ($this->guard()->check())
            return redirect()->route('A-dashboard');
        else {
            return view('admin/auth/login');
        }

    }

    function login(Request $request)
    {

        $validator = \Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
            //'g-recaptcha-response' => 'required|captcha'
        ]);

        if (!$validator->fails()):
            $user = AdminUser::Where("email", $request->email)->first();
            if ($user) {
                if (\Hash::check($request->input('password'), $user->password)) {
                    if ($user->access == 0) {
                        $request->session()->flash('Error', 'دسترسی اکانت شما بسته شده است و با پشتیبانی ارتباط برقرار کنید.');
                    } elseif ($user->access == 1) {

                        session()->put("email", $request->email);
                        session()->put("mobile", $user->mobile);
                        session()->put("password", $request->password);
                        session()->put("remember", $request->remember);
                        if ($user->sms2fa == 1) {

                            $randstring = rand(10000, 99999);
                            Session::put("verify_code", $randstring);

                            $platform_sms = 'sms';
                            try {
                                if ($platform_sms == 'sms') {
                                    SmsIr::login(Session::get('mobile'), Session::get('verify_code'));
                                }else {
                                    \Kavenegar::VerifyLookup(Session::get('mobile'), Session::get('verify_code'), null, null, 'VerifyMobile');
                                }
                                $request->session()->flash('Success', 'کد ورود برای شما پیامک شد.');
                                return redirect()->route('A-sms2fa');
                            }catch (\Exception $e) {
                                $request->session()->flash('Error', 'ارسال پیامک برای ورود دو مرحله ای امکان پذیر نیست.');
                                return redirect()->back();
                            }
                        } elseif ($user->google2fa != "") {
                            Session::put("google2fa", true);
                            return redirect()->route('A-google2fa');
                        } else {
                            if (isset($request->remember))
                                $this->guard()->loginUsingId($user->id, true);
                            else
                                $this->guard()->loginUsingId($user->id);
                            $functions = new \App\functions();
                            $functions->LogAdmin('ورود','login',$user->id);
                            return redirect()->route('A-dashboard');
                            $request->session()->flash('Success', 'ورود با موفقیت انجام شد.');
                        }
                    }
                } else {
                    $request->session()->flash('Error', 'اطلاعات وارد شده موجود نمی باشد، کوچک و بزرگ بودن حروف خود را چک کنید.');
                }
            } else {
                $request->session()->flash('Error', 'اطلاعات وارد شده موجود نمی باشد، کوچک و بزرگ بودن حروف خود را چک کنید.');
            }
        else:
            $request->session()->flash('Error', $validator->errors()->first());
        endif;
        return redirect()->back();
    }

    function logout()
    {
        $functions = new \App\functions();
        $functions->LogAdmin('خروج','logout',$this->guard()->user()->id);
        $this->guard()->logout();
        session()->flash('Success', 'شما با موفقیت خارج شدید .');
        return redirect(Route('A-login'))->withCookie(\Cookie::forget('NTime'));

    }


    function sms2faIndex()
    {
        if ($this->guard()->check())
            return redirect()->route('A-dashboard');
        elseif (Session::has('email') && Session::has('password') && Session::has('verify_code')) {
            $pageConfigs = [
                'bodyClass' => "bg-full-screen-image",
                'blankPage' => true
            ];
            return view('/admin.auth.auth-sms2fa', [
                'pageConfigs' => $pageConfigs
            ]);
        } else
            return redirect()->route('A-login');
    }

    function sms2fa(Request $request)
    {
        if ($this->guard()->check())
            return redirect()->route('A-dashboard');
        elseif (Session::has('email') && Session::has('mobile') && Session::has('password') && Session::has('verify_code')) {

            $user = AdminUser::Where("mobile", Session::get('mobile'))->Where("email", Session::get('email'))->first();
            if (Session::get('verify_code') == $request->code && $user && \Hash::check(Session::get('password'), $user->password)) {

                Session()->forget('mobile');
                Session()->forget('email');
                Session()->forget('password');
                Session()->forget('verify_code');

                if (Session::has('remember'))
                    $this->guard()->loginUsingId($user->id, true);
                else
                    $this->guard()->loginUsingId($user->id);

                $functions = new \App\functions();
                $functions->LogAdmin('ورود با دو مرحله ای پیامک','login',$this->guard()->user()->id);

                $request->session()->flash('Success', 'ورود با موفقیت انجام شد.');
                return redirect()->route('A-dashboard');
            } else {
                $request->session()->flash('Error', 'کد درج شده اشتباه است!');
                return redirect()->back();
            }
        } else
            return redirect()->route('A-login');
    }



    function google2faIndex()
    {
        if ($this->guard()->check())
            return redirect()->route('A-dashboard');
        elseif (Session::has('email') && Session::has('mobile') && Session::has('password') && Session::has('google2fa')) {
            $pageConfigs = [
                'bodyClass' => "bg-full-screen-image",
                'blankPage' => true
            ];
            return view('/admin.auth.auth-google2fa', [
                'pageConfigs' => $pageConfigs
            ]);
        } else
            return redirect()->route('A-login');
    }

    function google2fa(Request $request)
    {
        if ($this->guard()->check())
            return redirect()->route('A-dashboard');
        elseif (Session::has('email') && Session::has('mobile') && Session::has('password') && Session::has('google2fa')) {

            $google2fa = new Google2FA(new \BaconQrCode\Renderer\Image\SvgImageBackEnd());

            $user = AdminUser::Where("mobile", Session::get('mobile'))->Where("email", Session::get('email'))->first();
            $valid = $google2fa->verifyKey($user->google2fa, $request->code);

            if ($valid == 1 && $user && \Hash::check(Session::get('password'), $user->password)) {

                Session()->forget('mobile');
                Session()->forget('email');
                Session()->forget('password');
                Session()->forget('google2fa');

                if (Session::has('remember'))
                    $this->guard()->loginUsingId($user->id, true);
                else
                    $this->guard()->loginUsingId($user->id);

                $functions = new \App\functions();
                $functions->LogAdmin('ورود با دو مرحله ای گوگل','login',$this->guard()->user()->id);

                $request->session()->flash('Success', 'ورود با موفقیت انجام شد.');
                return redirect()->route('A-dashboard');
            } else {
                $request->session()->flash('Error', 'کد درج شده اشتباه است!' );
                return redirect()->back();
            }
        } else
            return redirect()->route('A-login');
    }


    function sms2faResend()
    {
        $platform_sms = 'sms';
        try {
            if ($platform_sms == 'sms') {
                SmsIr::login(Session::get('mobile'), Session::get('verify_code'));
            }else {
                \Kavenegar::VerifyLookup(Session::get('mobile'), Session::get('verify_code'), null, null, 'VerifyMobile');
            }
            $result = [
                'status' => true,
                'message' => 'با موفقیت ارسال شد'
            ];
        }catch (\Exception $e) {
            $result = [
                'status' => false,
                'message' => 'ارسال پیامک امکان پذیر نیست.'
            ];
        }
        return response()->json($result);
    }

    protected function guard()
    {
        return Auth::guard('admin');
    }
}
