<?php

namespace App\Http\Controllers\Admin;

use App\Orders;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Morilog\Jalali;
use DB;
use Image;
use App\functions;
use SoulDoit\DataTable\SSP;


class ActionsController extends Controller
{
    public function index_users(){

        $functions = new \App\functions;
        $users = \App\User::select('id','name','family','code_meli','mobile','created_at','updated_at','wallet','auth_img_confirm','selfie_img_confirm','phone')
            ->latest('created_at')
            ->orWhere('auth_img_confirm', [2])
            ->orWhere('selfie_img_confirm', [2])
            ->paginate(10);
        foreach ($users as $user) {
            $user->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($user->created_at));
        }

        return view('admin.actions.users', ['users'=>$users]);
    }

    public function index_finance(){

        $functions = new \App\functions;
        $finances = \App\UserFinance::select('users_finance.id','users_finance.type','users_finance.status','users_finance.description','users_finance.amount','users_finance.created_at','users_finance.ip','users.name','users.family','users.mobile','users.wallet','users_cardbank.bank_name','users_cardbank.card_number','users_cardbank.account_number','users_cardbank.shaba')
            ->leftJoin('users', 'users_finance.id_user', '=', 'users.id')
            ->leftJoin('users_cardbank', 'users_finance.id_cardbank', '=', 'users_cardbank.id')
            ->latest('created_at')
            ->Where('type', ['برداشت'])
            ->Where('status', ['در دست اقدام'])
            ->paginate(10);
        foreach ($finances as $finance) {
            $finance->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($finance->created_at));
        }

        return view('admin.actions.finance', ['finances'=>$finances]);
    }

    public function index_orders(){

        $functions = new \App\functions;
        $orders = \App\Orders::select('orders.id','orders.status','orders.type','orders.payment','orders.orders_model','orders.created_at','orders_cryptocurrency.coin','orders_cryptocurrency.amount_coin','users.name','users.family','users.mobile')
            ->leftJoin('users', 'orders.id_user', '=', 'users.id')
            ->leftJoin('orders_cryptocurrency', 'orders.id', '=', 'orders_cryptocurrency.id_order')
            ->latest('created_at')
            ->orWhere('status', ['در دست اقدام'])
            ->orWhere('status', ['در حال پردازش'])
            ->paginate(10);
        foreach ($orders as $order) {
            $order->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));
        }

        return view('admin.actions.orders', ['orders'=>$orders]);

    }

    public function index_wallet(){
        return view('admin.actions.wallet');
    }
    public function list_wallet(Request $request)
    {
        $result["data"] = array();
        $Wallet = \App\Wallet::orderBy('id','desc')->where('confirm',0)->get();

        foreach($Wallet as $wallet):
            $array = array();
            $user = User::find($wallet->id_user);
            $array["2"] = $user->name.' '.$user->family.'<br>'.$user->mobile;
            $array["3"] = $wallet->coin_name;
            $array["4"] = $wallet->wallet;
            $array["5"] = Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($wallet->created_at));
            $array["6"] = '<span class="badge bg-warning m-1 font-weight-light">منتظر تایید</span>';

            $array["7"] =  '<a href="' . asset('') .env('PanelPrefix'). '/users/' . $user->id . '"
                            class="btn btn-light">مشاهده</a>';
            array_push($result["data"], $array);
        endforeach;
        return response()->json($result);
    }

    public function all_confirm_orders(Request $request){
        $functions = new functions;
        $result = array();
        $IDs = explode(',',$request->IDs);
        $orders = Orders::whereIn('id',$IDs)->where('type','sell')->whereNull('payment')->whereNotNull('id_cardbank')->where('status','در حال پردازش')->orderBy('id','desc')->get();

        foreach($orders as $order):
            $order->user = User::find($order->id_user);
            $order->detail = $functions->get_order_detail($order->id);
            $order->date =  Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($order->created_at));;
        endforeach;

        $result['orders'] = $orders;
        return view('admin.actions.orders-allconfirm',['result'=>$result]);
    }

    public function confirm_orders(Request $request){
        $functions = new functions;
        $request->IDs = json_decode($request->IDs);
        $orders = Orders::whereIn('id',$request->IDs)->get();
        foreach($orders as $order){
            $order->status = 'پرداخت شده';
            $order->payment = $order->amount;
            $order->id_admin = Auth::user()->id;
            $order->save();

            $user = User::find($order->id_user);
			try{\Kavenegar::VerifyLookup($user->mobile,$order->amount,$request->payment,null,'settle');}
			catch (\Exception $ex){}

            if(isset($user->firebase_token))
                $functions->send_notification('واریز به حساب',$user->family.' عزیز، مبلغ '.$order->amount.' به حساب شما '.$request->payment.' شد.',$user->firebase_token);

        }
        $result = array('status' => true , 'messege' => 'با موفقیت تایید و پرداخت شد');
        return response()->json($result);
    }



    public function index_cardbank(){

        $functions = new \App\functions;
        $cards = \App\CardBank::select('users_cardbank.id','users_cardbank.id_user','users_cardbank.bank_name','users_cardbank.card_number','users_cardbank.account_number','users_cardbank.confirm','users_cardbank.created_at','users.name','users.family','users.mobile')
            ->leftJoin('users', 'users_cardbank.id_user', '=', 'users.id')
            ->latest('created_at')
            ->Where('confirm', ['0'])
            ->paginate(10);
        foreach ($cards as $card) {
            $card->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($card->created_at));
        }

        return view('admin.actions.cardbank', ['cards'=>$cards]);
    }

    public function all_confirm_finance(Request $request){

        $result = array();
        $IDs = explode(',',$request->IDs);
        $finances =  \App\UserFinance::whereIn('id',$IDs)->whereNotNull('id_cardbank')->where('status','در دست اقدام')->orderBy('id','desc')->get();

        foreach($finances as $finance):
            $finance->user = User::find($finance->id_user);
            $finance->date =  Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($finance->created_at));;
        endforeach;

        $result['finances'] = $finances;
        return view('admin.actions.finance-allconfirm',['result'=>$result]);
    }

    public function confirm_finance(Request $request){

        $functions = new functions;
        $request->IDs = json_decode($request->IDs);
        $finances = \App\UserFinance::whereIn('id',$request->IDs)->get();
        foreach($finances as $finance){
            $finance->payment = $finance->amount;
            $finance->status = 'واریز شده';
            $finance->description = 'از طریق '.$request->via.' واریز شد';
            $finance->id_admin = \Auth::user()->id;
            $finance->save();

            $user = User::find($finance->id_user);
			try{\Kavenegar::VerifyLookup($user->mobile,$finance->amount,$request->via,null,'settle');}
			catch (\Exception $ex){}

            if(isset($user->firebase_token))
                $functions->send_notification('واریز به حساب',$user->family.' عزیز، مبلغ '.$finance->amount.' به حساب شما '.$request->via.' شد.',$user->firebase_token);

        }
        $result = array('status' => true , 'messege' => 'با موفقیت تایید و پرداخت شد');
        return response()->json($result);
    }

}
