<?php

namespace App\Helpers\Payment\Banks;

use App\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class Zarinpal
{
    /**
     * @var \Illuminate\Database\Eloquent\HigherOrderBuilderProxy|mixed
     */
    private $Token = 555;

    /**
     * @var string[]
     */
    private $headers = [
        'Accept: application/json',
        'charset: utf-8',
        'Content-Type: application/json',
    ];


    public function __construct() {
        $this->Token = Settings::query()
            ->where('name','ZarinpalToken')
            ->first()->value;
    }


    public function request($amount, $CallbackURL, $params = null)
    {
        $user = Auth::user();
        $data = [
            "merchant_id" => $this->Token,
            "amount" => $amount*10,
            "callback_url" => $CallbackURL,
            "description" => 'شارژ کیف پول ',
            "metadata" => [
                "email" => $user->email,
                "mobile" => $user->mobile
            ],
        ];

        $request = Http::withHeaders($this->headers)
            ->post('https://api.zarinpal.com/pg/v4/payment/request.json', $data);

        $response = json_decode($request->getBody()->getContents(), true);

        if (!empty($response['errors'])|| !empty($response['data']['code']) != 100){

            return $response['errors']['message'] . ':' .  $response['errors']['code'];
        }

        header('Location:https://www.zarinpal.com/pg/StartPay/' . $response['data']['authority']);exit();
    }

    /**
     * @param $params
     * @return mixed
     */
    public function verify ($params)
    {
        $data = [
            "merchant_id" => $this->Token,
            "authority" => $params['Authority'],
            "amount" => $params['amount']
        ];

        $request = Http::withHeaders($this->headers)
            ->post('https://api.zarinpal.com/pg/v4/Payment/verify.json', $data);

        $result = json_decode($request->getBody()->getContents(), true);
        if(isset($result['data']['code']) && $result['data']['code'] == 100) {
            return $result;
        }
        return [
            'status' => false,
            'message' => "پرداخت با شکست مواجه شد!"
        ];
    }


}
