<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DepositWithdrawal extends Model
{
    protected $table = 'deposits_withdrawals';

    protected $fillable = [
        'user_id',
        'type',
        'currency',
        'amount',
        'fee',
        'address',
        'txid',
        'network',
        'status',
        'admin_note',
        'completed_at',
    ];

    protected $casts = [
        'amount' => 'decimal:8',
        'fee' => 'decimal:8',
        'completed_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Check if deposit
     */
    public function isDeposit()
    {
        return $this->type === 'deposit';
    }

    /**
     * Check if withdrawal
     */
    public function isWithdrawal()
    {
        return $this->type === 'withdrawal';
    }

    /**
     * Check if completed
     */
    public function isCompleted()
    {
        return $this->status === 'completed';
    }

    /**
     * Check if pending
     */
    public function isPending()
    {
        return $this->status === 'pending';
    }
}
